/*
 * Decompiled with CFR 0.152.
 */
package Typing;

import Typing.TypingPractice;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class LafDialog
extends JDialog
implements ItemListener,
ActionListener {
    private String mac = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private String metal = "javax.swing.plaf.metal.MetalLookAndFeel";
    private String motif = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private String windows = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private String currentLookAndFeel;
    private String newLookAndFeel;
    private JRadioButton macRb;
    private JRadioButton metalRb;
    private JRadioButton motifRb;
    private JRadioButton windowsRb;
    private ButtonGroup lafButtonGroup;
    private JButton okButton;
    private JButton cancelButton;
    private JButton applyButton;
    private TypingPractice mainFrame;

    public LafDialog(TypingPractice typingPractice, String string) {
        super(typingPractice, "Look And Feel", true);
        this.setTitle("Look And Feel");
        this.mainFrame = typingPractice;
        this.setCurrentLookAndFeel(string);
        this.newLookAndFeel = this.currentLookAndFeel;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(null, "Look And Feel"));
        this.lafButtonGroup = new ButtonGroup();
        jPanel.add(Box.createVerticalGlue());
        this.metalRb = this.createLafRadioButton("Java Look & Feel", 'J', this.metal);
        this.metalRb.addItemListener(this);
        jPanel.add(this.metalRb);
        this.macRb = this.createLafRadioButton("Macintosh Look & Feel", 'M', this.mac);
        this.macRb.addItemListener(this);
        jPanel.add(this.macRb);
        this.motifRb = this.createLafRadioButton("Motif Look & Feel", 'f', this.motif);
        this.motifRb.addItemListener(this);
        jPanel.add(this.motifRb);
        this.windowsRb = this.createLafRadioButton("Windows Look & Feel", 'W', this.windows);
        this.windowsRb.addItemListener(this);
        jPanel.add(this.windowsRb);
        jPanel.add(Box.createVerticalGlue());
        this.setRadioButtonSelected();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 4, 0));
        jPanel2.add(Box.createVerticalStrut(40));
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(new Dimension(75, 25));
        this.okButton.addActionListener(this);
        jPanel2.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(75, 25));
        this.cancelButton.addActionListener(this);
        jPanel2.add(this.cancelButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setPreferredSize(new Dimension(75, 25));
        this.applyButton.addActionListener(this);
        jPanel2.add(this.applyButton);
        jPanel2.add(Box.createVerticalStrut(40));
        container.add(Box.createVerticalStrut(5), "North");
        container.add(Box.createHorizontalStrut(15), "West");
        container.add(Box.createHorizontalStrut(15), "East");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        this.setVisible(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (LafDialog.this.currentLookAndFeel != LafDialog.this.newLookAndFeel) {
                    LafDialog.this.newLookAndFeel = LafDialog.this.currentLookAndFeel;
                    if (LafDialog.this.currentLookAndFeel.equals(LafDialog.this.metal)) {
                        LafDialog.this.metalRb.setSelected(true);
                    } else if (LafDialog.this.currentLookAndFeel.equals(LafDialog.this.mac)) {
                        LafDialog.this.macRb.setSelected(true);
                    } else if (LafDialog.this.currentLookAndFeel.equals(LafDialog.this.motif)) {
                        LafDialog.this.motifRb.setSelected(true);
                    } else {
                        LafDialog.this.windowsRb.setSelected(true);
                    }
                }
                LafDialog.this.setVisible(false);
            }
        });
    }

    private JRadioButton createLafRadioButton(String string, char c, String string2) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setMnemonic(c);
        this.lafButtonGroup.add(jRadioButton);
        jRadioButton.setEnabled(this.isAvailableLookAndFeel(string2));
        return jRadioButton;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.metalRb) {
            this.newLookAndFeel = this.metal;
        } else if (itemEvent.getSource() == this.macRb) {
            this.newLookAndFeel = this.mac;
        } else if (itemEvent.getSource() == this.motifRb) {
            this.newLookAndFeel = this.motif;
        } else if (itemEvent.getSource() == this.windowsRb) {
            this.newLookAndFeel = this.windows;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            if (this.newLookAndFeel != this.currentLookAndFeel) {
                this.currentLookAndFeel = this.newLookAndFeel;
                this.updateLookAndFeel(this.currentLookAndFeel);
            }
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.newLookAndFeel = this.currentLookAndFeel;
            this.setRadioButtonSelected();
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.applyButton) {
            this.currentLookAndFeel = this.newLookAndFeel;
            this.updateLookAndFeel(this.currentLookAndFeel);
        }
    }

    public void updateLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(this);
            SwingUtilities.updateComponentTreeUI(this.mainFrame);
            this.mainFrame.exercise.upDown.updateLookAndFeel();
            SwingUtilities.updateComponentTreeUI(this.mainFrame.controls.popup);
            SwingUtilities.updateComponentTreeUI(this.mainFrame.controls.myHelp);
            SwingUtilities.updateComponentTreeUI(this.mainFrame.aPane.tccp.getPopupMenu());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    protected boolean isAvailableLookAndFeel(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
            return lookAndFeel.isSupportedLookAndFeel();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getCurrentLookAndFeel() {
        return this.currentLookAndFeel;
    }

    public void setCurrentLookAndFeel(String string) {
        this.currentLookAndFeel = string;
    }

    private void setRadioButtonSelected() {
        if (this.currentLookAndFeel.equals(this.metal)) {
            this.metalRb.setSelected(true);
        } else if (this.currentLookAndFeel.equals(this.mac)) {
            this.macRb.setSelected(true);
        } else if (this.currentLookAndFeel.equals(this.motif)) {
            this.motifRb.setSelected(true);
        } else if (this.currentLookAndFeel.equals(this.windows)) {
            this.windowsRb.setSelected(true);
        }
    }
}

