/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

class SRPrefs
implements Serializable {
    private Point screenLocation;
    private Dimension windowSize;
    private int charsPerLine;
    private int delay;
    private boolean extraDelay;
    private String windowTitle;
    private Color bkgColor;
    private Color fgColor;
    private String fontName;
    private int fontStyle;
    private int fontSize;

    public SRPrefs() {
        this.setScreenLocation(new Point(0, 0));
        this.setWindowSize(new Dimension(250, 100));
        this.setCharsPerLine(10);
        this.setDelay(150);
        this.setExtraDelay(false);
        this.setWindowTitle("Speed Reader");
        this.setBkgColor(Color.black);
        this.setFgColor(Color.white);
        this.setFontName("Monospaced");
        this.setFontStyle(0);
        this.setFontSize(12);
    }

    public Point getScreenLocation() {
        return this.screenLocation;
    }

    public void setScreenLocation(Point point) {
        this.screenLocation = point;
    }

    public Dimension getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(Dimension dimension) {
        this.windowSize = dimension;
    }

    public int getCharsPerLine() {
        return this.charsPerLine;
    }

    public void setCharsPerLine(int n) {
        this.charsPerLine = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public void setExtraDelay(boolean bl) {
        this.extraDelay = bl;
    }

    public boolean delayLongWords() {
        return this.extraDelay;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setWindowTitle(String string) {
        this.windowTitle = string;
    }

    public Color getBkgColor() {
        return this.bkgColor;
    }

    public void setBkgColor(Color color) {
        this.bkgColor = color;
    }

    public Color getFgColor() {
        return this.fgColor;
    }

    public void setFgColor(Color color) {
        this.fgColor = color;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public void setFontStyle(int n) {
        this.fontStyle = n;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public Font getFont() {
        return new Font(this.fontName, this.fontStyle, this.fontSize);
    }

    public Frame makeFrame(ActionListener actionListener) {
        Frame frame = new Frame("Speed Reader Preferences");
        frame.setLayout(new BorderLayout(15, 15));
        ((Component)frame).setBackground(Color.lightGray);
        frame.add((Component)new Label(" "), "North");
        Panel panel = new Panel(new GridLayout(0, 2, 5, 5));
        TextField textField = new TextField(this.getWindowTitle());
        panel.add(new Label("Window Title: "));
        panel.add(textField);
        Choice choice = new Choice();
        choice.addItem("Serif");
        choice.addItem("SanSerif");
        choice.addItem("Monospaced");
        choice.addItem("Dialog");
        choice.addItem("DialogInput");
        choice.select(this.getFontName());
        panel.add(new Label("Font name: "));
        panel.add(choice);
        Choice choice2 = new Choice();
        choice2.addItem("8");
        choice2.addItem("10");
        choice2.addItem("12");
        choice2.addItem("14");
        choice2.addItem("16");
        choice2.addItem("18");
        choice2.addItem("20");
        choice2.addItem("22");
        choice2.addItem("24");
        choice2.addItem("26");
        choice2.addItem("28");
        choice2.addItem("30");
        choice2.addItem("32");
        choice2.select(String.valueOf(this.getFontSize()));
        panel.add(new Label("Font size: "));
        panel.add(choice2);
        TextField textField2 = new TextField(String.valueOf(this.getCharsPerLine()));
        TextField textField3 = new TextField(String.valueOf(this.getDelay()));
        Checkbox checkbox = new Checkbox("Extra Delay for long words", this.delayLongWords());
        panel.add(new Label("Characters per line: "));
        panel.add(textField2);
        panel.add(new Label("Delay in mS: "));
        panel.add(textField3);
        panel.add(new Label(""));
        panel.add(checkbox);
        frame.add((Component)panel, "West");
        Panel panel2 = new Panel();
        Panel panel3 = new Panel(new GridLayout(0, 1));
        panel3.add(new Label("Foreground color"));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        panel3.add(new ColorCheckbox("White", checkboxGroup, this.fgColor.equals(Color.white), Color.white));
        panel3.add(new ColorCheckbox("Blue", checkboxGroup, this.fgColor.equals(Color.blue), Color.blue));
        panel3.add(new ColorCheckbox("Gray", checkboxGroup, this.fgColor.equals(Color.gray), Color.gray));
        panel3.add(new ColorCheckbox("Yellow", checkboxGroup, this.fgColor.equals(Color.yellow), Color.yellow));
        panel3.add(new ColorCheckbox("Red", checkboxGroup, this.fgColor.equals(Color.red), Color.red));
        panel3.add(new ColorCheckbox("Cyan", checkboxGroup, this.fgColor.equals(Color.cyan), Color.cyan));
        panel3.add(new ColorCheckbox("Black", checkboxGroup, this.fgColor.equals(Color.black), Color.black));
        panel2.add(panel3);
        Panel panel4 = new Panel(new GridLayout(0, 1));
        panel4.add(new Label("Background color"));
        CheckboxGroup checkboxGroup2 = new CheckboxGroup();
        panel4.add(new ColorCheckbox("White", checkboxGroup2, this.bkgColor.equals(Color.white), Color.white));
        panel4.add(new ColorCheckbox("Blue", checkboxGroup2, this.bkgColor.equals(Color.blue), Color.blue));
        panel4.add(new ColorCheckbox("Gray", checkboxGroup2, this.bkgColor.equals(Color.gray), Color.gray));
        panel4.add(new ColorCheckbox("Yellow", checkboxGroup2, this.bkgColor.equals(Color.yellow), Color.yellow));
        panel4.add(new ColorCheckbox("Red", checkboxGroup2, this.bkgColor.equals(Color.red), Color.red));
        panel4.add(new ColorCheckbox("Cyan", checkboxGroup2, this.bkgColor.equals(Color.cyan), Color.cyan));
        panel4.add(new ColorCheckbox("Black", checkboxGroup2, this.bkgColor.equals(Color.black), Color.black));
        panel2.add(panel4);
        frame.add((Component)panel2, "East");
        Panel panel5 = new Panel(new GridLayout(0, 2, 25, 10));
        Button button = new Button("OK");
        button.setActionCommand("PrefsFrameOK");
        button.addActionListener(new 1(checkboxGroup2, textField2, textField3, checkbox, checkboxGroup, choice, choice2, this, textField));
        button.addActionListener(actionListener);
        Button button2 = new Button("Cancel");
        button2.setActionCommand("PrefsFrameCancel");
        button2.addActionListener(actionListener);
        panel5.add(button);
        panel5.add(button2);
        frame.add((Component)panel5, "South");
        frame.pack();
        return frame;
    }

    private static final class 1
    implements ActionListener {
        private final /* synthetic */ CheckboxGroup val$fgCbg;
        private final /* synthetic */ CheckboxGroup val$bgCbg;
        private final /* synthetic */ Choice val$fontSizeChoice;
        private final /* synthetic */ Choice val$fontNameChoice;
        private final /* synthetic */ TextField val$wntTf;
        private final /* synthetic */ Checkbox val$edcb;
        private final /* synthetic */ TextField val$dlyTf;
        private final /* synthetic */ SRPrefs this$0;
        private final /* synthetic */ TextField val$cplTf;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.setCharsPerLine(Integer.valueOf(this.val$cplTf.getText()));
            this.this$0.setDelay(Integer.valueOf(this.val$dlyTf.getText()));
            this.this$0.setExtraDelay(this.val$edcb.getState());
            this.this$0.setWindowTitle(this.val$wntTf.getText());
            this.this$0.setFontName(this.val$fontNameChoice.getSelectedItem());
            this.this$0.setFontSize(Integer.parseInt(this.val$fontSizeChoice.getSelectedItem()));
            this.this$0.setBkgColor(this.val$bgCbg.getSelectedCheckbox().getForeground());
            this.this$0.setFgColor(this.val$fgCbg.getSelectedCheckbox().getForeground());
        }

        /* synthetic */ 1(CheckboxGroup checkboxGroup, TextField textField, TextField textField2, Checkbox checkbox, CheckboxGroup checkboxGroup2, Choice choice, Choice choice2, SRPrefs sRPrefs, TextField textField3) {
            this.val$bgCbg = checkboxGroup;
            this.val$cplTf = textField;
            this.val$dlyTf = textField2;
            this.val$edcb = checkbox;
            this.val$fgCbg = checkboxGroup2;
            this.val$fontNameChoice = choice;
            this.val$fontSizeChoice = choice2;
            this.this$0 = sRPrefs;
            this.val$wntTf = textField3;
        }
    }
}

