/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;

public class GBisectorDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "bisector.gif";
    public static final Dimension ICONDIM = new Dimension(120, 82);
    private GSolid solid;
    private TextField[] p;
    private String imageDir;

    public GBisectorDialog(GFrame gFrame, GSolid gSolid, int n, Object[] objectArray) {
        super(gFrame, "Bisect Angle");
        this.helpTopic = "draw bisector";
        this.solid = gSolid;
        this.p = new TextField[3];
        int n2 = 0;
        while (n2 < 3) {
            this.p[n2] = new TextField(3);
            this.p[n2].setFont(gFrame.labelFont);
            ++n2;
        }
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.set(n, objectArray);
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        Label label = new Label("Draw the bisector of angle labeled:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets.right = 5;
        gridBagLayout.setConstraints(this.p[0], gridBagConstraints);
        this.dataPanel.add(this.p[0]);
        gridBagConstraints.insets.left = 5;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(this.p[1], gridBagConstraints);
        this.dataPanel.add(this.p[1]);
        gridBagConstraints.anchor = 15;
        gridBagLayout.setConstraints(this.p[2], gridBagConstraints);
        this.dataPanel.add(this.p[2]);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public Object[] getFields() {
        Object[] objectArray = new Object[]{this.p[0].getText().toUpperCase(), this.p[1].getText().toUpperCase(), this.p[2].getText().toUpperCase()};
        return objectArray;
    }

    protected void setFields(Object[] objectArray) {
        ((TextComponent)this.p[0]).setText((String)objectArray[0]);
        ((TextComponent)this.p[1]).setText((String)objectArray[1]);
        ((TextComponent)this.p[2]).setText((String)objectArray[2]);
    }

    protected boolean onOk() {
        String[] stringArray = new String[]{this.p[0].getText().toUpperCase(), this.p[1].getText().toUpperCase(), this.p[2].getText().toUpperCase()};
        if (stringArray[0].equals("") || stringArray[1].equals("") || stringArray[2].equals("") || stringArray[0].equals(stringArray[1]) || stringArray[0].equals(stringArray[2])) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "Angle improperly referenced");
            return false;
        }
        String string = this.solid.drawBisector(stringArray);
        if (string != null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Draw Failed", string);
            return false;
        }
        return true;
    }

    public void set(int n, Object[] objectArray) {
        if (n == 2) {
            this.setFields(objectArray);
        } else {
            this.setTitle("Bisect Angle in Solid " + this.solid.getLabel());
            GEdgeList gEdgeList = this.solid.getSelectedEdges().renderToAngle();
            if (gEdgeList != null) {
                GEdgeNode gEdgeNode = gEdgeList.getHead();
                GEdge gEdge = gEdgeNode.getEdge();
                GEdge gEdge2 = gEdgeNode.getNext().getEdge();
                String string = gEdge.getHead().getLabel();
                String string2 = gEdge.getTail().getLabel();
                String string3 = gEdge2.getHead().getLabel();
                String string4 = gEdge2.getTail().getLabel();
                if (string.equals(string3)) {
                    ((TextComponent)this.p[0]).setText(string);
                    ((TextComponent)this.p[1]).setText(string2);
                    ((TextComponent)this.p[2]).setText(string4);
                } else if (string.equals(string4)) {
                    ((TextComponent)this.p[0]).setText(string);
                    ((TextComponent)this.p[1]).setText(string2);
                    ((TextComponent)this.p[2]).setText(string3);
                } else if (string2.equals(string3)) {
                    ((TextComponent)this.p[0]).setText(string2);
                    ((TextComponent)this.p[1]).setText(string);
                    ((TextComponent)this.p[2]).setText(string4);
                } else if (string2.equals(string4)) {
                    ((TextComponent)this.p[0]).setText(string2);
                    ((TextComponent)this.p[1]).setText(string);
                    ((TextComponent)this.p[2]).setText(string3);
                }
            }
        }
        if (n == 0) {
            this.show();
            return;
        }
        this.result = this.onOk() ? 0 : 1;
    }
}

