/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class GCFrame
extends GFrame {
    public static final String TITLE = "GEOMETRIA Composer";
    private TextArea hypothesisView;

    public GCFrame() {
        this.menuBar = new GCMenuBar(this);
        this.setMenuBar(this.menuBar);
        this.hypothesisView = new TextArea("", 4, 30, 1);
        this.hypothesisView.setFont(this.labelFont);
        this.layComponents();
        this.show();
        this.newProblem();
        this.hypothesisView.requestFocus();
    }

    protected Component decorateHypothesisView() {
        return this.hypothesisView;
    }

    protected void newProblem() {
        GProblem gProblem = this.problem;
        if (this.problem != null) {
            this.problem.close();
        }
        this.menuBar.initWindowMenu();
        this.problem = new GCProblem(this, (GCMenuBar)this.menuBar, this.hypothesisView, this.calculator, this.notepad);
        this.setProblem(gProblem, this.problem);
        this.calculator.flush();
        this.notepad.flush();
        this.hypothesisView.setText("");
        this.setTitle("GEOMETRIA Composer: " + this.problem.getName());
    }

    protected void openProblem() {
        GFileDialog gFileDialog = new GFileDialog(this, "Open Problem", this.problemDir, 0);
        this.problemDir = gFileDialog.getDirectory();
        String string = gFileDialog.getFile();
        if (this.problemDir != null && this.problemDir.length() != 0 && string != null && string.length() != 0) {
            FileInputStream fileInputStream;
            Object object;
            try {
                object = new File(this.problemDir, string);
                fileInputStream = new FileInputStream((File)object);
            }
            catch (IOException iOException) {
                new GAlertDialog(this, "warn.gif", "GEOMETRIA", "File not found");
                return;
            }
            try {
                object = new ObjectInputStream(fileInputStream);
                Object object2 = ((ObjectInputStream)object).readObject();
                if (!(object2 instanceof GCProblem)) {
                    new GAlertDialog(this, "warn.gif", "GEOMETRIA", "File contains no GEOMETRIA problem");
                    return;
                }
                GCProblem gCProblem = (GCProblem)object2;
                this.problem.close();
                gCProblem.setName(string);
                this.menuBar.initWindowMenu();
                this.setProblem(this.problem, gCProblem);
                this.problem = gCProblem;
                ((GCProblem)this.problem).init();
                this.hypothesisView.setText(this.problem.getHypothesis());
                this.calculator.flush();
                this.notepad = this.problem.notepad;
                this.notepad.redraw();
                this.setTitle("GEOMETRIA Composer: " + this.problem.getName());
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(classNotFoundException.toString());
                return;
            }
            catch (IOException iOException) {
                new GAlertDialog(this, "warn.gif", "GEOMETRIA Warning", "File contains no GEOMETRIA problem");
                return;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        GMenuItem gMenuItem = (GMenuItem)actionEvent.getSource();
        GMenu gMenu = (GMenu)gMenuItem.getParent();
        if (gMenu == this.menuBar.fileMenu && gMenuItem == ((GCMenuBar)this.menuBar).newproblemMenuItem && this.problem.onClose()) {
            this.newProblem();
        }
    }
}

