/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class GJoinDialog
extends GOkCancelHelpDialog
implements ItemListener {
    public static final String ICONFILE = "join.gif";
    public static final Dimension ICONDIM = new Dimension(60, 141);
    private List solid1;
    private List solid2;
    private List facet1;
    private List facet2;
    private GSolidWndList solidWndList;
    private GSolid solidChoice1;
    private GSolid solidChoice2;
    private GSolid jointSolid;

    public GJoinDialog(GFrame gFrame, GSolidWndList gSolidWndList) {
        super(gFrame, "Join Solids");
        this.helpTopic = "join solids";
        this.solidWndList = gSolidWndList;
        this.facet1 = new List(4);
        this.facet1.setFont(gFrame.labelFont);
        this.facet2 = new List(4);
        this.facet2.setFont(gFrame.labelFont);
        this.solid1 = new List(4);
        this.solid1.setFont(gFrame.labelFont);
        this.solid1.addItemListener(this);
        this.solid2 = new List(4);
        this.solid2.setFont(gFrame.labelFont);
        this.solid2.addItemListener(this);
        this.layComponents();
        this.loadSolidNames(gSolidWndList);
        this.pack();
        this.positionLeft();
        this.show();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        Label label = new Label("Join:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 5;
        Label label2 = new Label("Facet:", 2);
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.facet1, gridBagConstraints);
        this.dataPanel.add(this.facet1);
        gridBagConstraints.insets.left = 10;
        Label label3 = new Label("In:", 2);
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagLayout.setConstraints(this.solid1, gridBagConstraints);
        this.dataPanel.add(this.solid1);
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 15;
        gridBagConstraints.insets.right = 25;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        Label label4 = new Label("To facet:", 2);
        gridBagLayout.setConstraints(label4, gridBagConstraints);
        this.dataPanel.add(label4);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.facet2, gridBagConstraints);
        this.dataPanel.add(this.facet2);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.gridx = 2;
        Label label5 = new Label("In:", 2);
        gridBagLayout.setConstraints(label5, gridBagConstraints);
        this.dataPanel.add(label5);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(this.solid2, gridBagConstraints);
        this.dataPanel.add(this.solid2);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected boolean onOk() {
        if (this.solid1.getSelectedItem() == null || this.solid2.getSelectedItem() == null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA", "Please select the solids to join");
            return false;
        }
        if (this.facet1.getSelectedItem() == null || this.facet2.getSelectedItem() == null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA", "Please select the facets to join");
            return false;
        }
        Object object = this.solidChoice1.join(this.solidChoice2, this.facet1.getSelectedItem(), this.facet2.getSelectedItem());
        if (object instanceof String) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Join Failed", (String)object);
            return false;
        }
        this.jointSolid = (GSolid)object;
        this.solidChoice1.clearSelection(true, true, true);
        this.solidChoice2.clearSelection(true, true, true);
        return true;
    }

    public GSolid getJointSolid() {
        return this.jointSolid;
    }

    public void loadSolidNames(GSolidWndList gSolidWndList) {
        GSolidWndNode gSolidWndNode = gSolidWndList.getHead();
        while (gSolidWndNode != null) {
            this.solid1.add("Solid " + gSolidWndNode.getSolid().getLabel());
            this.solid2.add("Solid " + gSolidWndNode.getSolid().getLabel());
            if (gSolidWndNode == gSolidWndList.getTop()) {
                this.solid1.select(this.solid1.getItemCount() - 1);
                this.itemStateChanged(new ItemEvent(this.solid1, 0, null, 0));
            } else if (gSolidWndList.getDim() == 2) {
                this.solid2.select(this.solid2.getItemCount() - 1);
                this.itemStateChanged(new ItemEvent(this.solid2, 0, null, 0));
            }
            gSolidWndNode = gSolidWndNode.getNext();
        }
    }

    protected void loadFacets(int n, GSolid gSolid) {
        List list = n == 1 ? this.facet1 : this.facet2;
        GFacetNode gFacetNode = gSolid.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            list.add(gFacet.toString());
            if (gFacet.isSelected()) {
                list.select(list.getItemCount() - 1);
            }
            gFacetNode = gFacetNode.getNext();
        }
        list.makeVisible(list.getSelectedIndex());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        List list = (List)itemEvent.getSource();
        GSolidWndNode gSolidWndNode = this.solidWndList.getHead();
        while (gSolidWndNode != null) {
            GSolid gSolid = gSolidWndNode.getSolid();
            if (list.getSelectedItem().equals("Solid " + gSolid.getLabel())) {
                if (list == this.solid1) {
                    this.solidChoice1 = gSolid;
                    this.loadFacets(1, gSolid);
                    return;
                }
                this.solidChoice2 = gSolid;
                this.loadFacets(2, gSolid);
                return;
            }
            gSolidWndNode = gSolidWndNode.getNext();
        }
    }
}

