/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class GLogDialog
extends GOkCancelHelpDialog
implements ItemListener,
KeyListener {
    public static final Dimension RECORDSAREA = new Dimension(300, 150);
    private GButton stepForthButton;
    private GButton clearDownButton;
    private GButton rewindButton;
    private GList records;
    private GRProblem problem;
    private GLog log;
    private int currSelected;
    private boolean autoSelected;

    public GLogDialog(GFrame gFrame, GRProblem gRProblem, GLog gLog) {
        super(gFrame, String.valueOf(GProblem.name) + ": Resolution Log");
        this.helpTopic = "review resolution";
        this.setModal(false);
        this.problem = gRProblem;
        this.log = gLog;
        this.stepForthButton = new GButton("Step Forth");
        this.stepForthButton.addActionListener(this);
        this.clearDownButton = new GButton("Clear Down");
        this.clearDownButton.addActionListener(this);
        this.rewindButton = new GButton("Rewind");
        this.rewindButton.addActionListener(this);
        this.cancelButton.setLabel("Close");
        this.records = new GList(8, RECORDSAREA, false);
        this.records.setFont(GDialog.frame.labelFont);
        this.records.addItemListener(this);
        this.records.addKeyListener(this);
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.init();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        gridBagLayout.setConstraints(this.records, gridBagConstraints);
        this.dataPanel.add(this.records);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagLayout.setConstraints(this.stepForthButton, gridBagConstraints);
        this.buttonsPanel.add(this.stepForthButton);
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.rewindButton, gridBagConstraints);
        this.buttonsPanel.add(this.rewindButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 10;
        gridBagLayout.setConstraints(this.clearDownButton, gridBagConstraints);
        this.buttonsPanel.add(this.clearDownButton);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagConstraints.insets.right = 10;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public boolean onOk() {
        return false;
    }

    public void init() {
        this.records.add("Resolution started");
        GLogRecordNode gLogRecordNode = this.log.recordList.getHead();
        while (gLogRecordNode != null) {
            this.records.add(gLogRecordNode.getRecord().toString());
            gLogRecordNode = gLogRecordNode.getNext();
        }
        this.selectLogItem(0);
    }

    protected void selectLogItem(int n) {
        this.autoSelected = true;
        this.records.select(n);
        this.currSelected = n;
        this.autoSelected = false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.records.getSelectedIndex();
        if (this.autoSelected) {
            return;
        }
        if (n != this.currSelected) {
            this.records.select(this.currSelected);
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.stepForthButton) {
            int n = this.records.getSelectedIndex();
            if (n == this.records.getItemCount() - 1) {
                return;
            }
            this.problem.oneStep(n);
            this.selectLogItem(n + 1);
            return;
        }
        if (actionEvent.getSource() == this.clearDownButton) {
            int n;
            int n2 = this.records.getSelectedIndex();
            if (n2 == (n = this.records.getItemCount()) - 1) {
                return;
            }
            GYNPromptDialog gYNPromptDialog = new GYNPromptDialog(GDialog.frame, "Erase resolution below the selected line?");
            if (gYNPromptDialog.result == 2) {
                this.problem.clearLog(n2);
                int n3 = n2 + 1;
                while (n3 < n) {
                    this.records.remove(this.records.getItemCount() - 1);
                    ++n3;
                }
                return;
            }
        } else {
            if (actionEvent.getSource() == this.rewindButton) {
                this.problem.rewind();
                this.selectLogItem(0);
                this.toFront();
                return;
            }
            if (actionEvent.getSource() == this.cancelButton) {
                this.problem.logDialogClosed();
                this.problem.restore();
            }
        }
    }
}

