/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class InputMap
implements Serializable {
    private transient AbstractAction.ArrayTable arrayTable;
    private InputMap parent;

    public void setParent(InputMap inputMap) {
        this.parent = inputMap;
    }

    public InputMap getParent() {
        return this.parent;
    }

    public void put(KeyStroke keyStroke, Object object) {
        if (keyStroke == null) {
            return;
        }
        if (object == null) {
            this.remove(keyStroke);
        } else {
            if (this.arrayTable == null) {
                this.arrayTable = new AbstractAction.ArrayTable();
            }
            this.arrayTable.put(keyStroke, object);
        }
    }

    public Object get(KeyStroke keyStroke) {
        InputMap inputMap;
        if (this.arrayTable == null) {
            InputMap inputMap2 = this.getParent();
            if (inputMap2 != null) {
                return inputMap2.get(keyStroke);
            }
            return null;
        }
        Object object = this.arrayTable.get(keyStroke);
        if (object == null && (inputMap = this.getParent()) != null) {
            return inputMap.get(keyStroke);
        }
        return object;
    }

    public void remove(KeyStroke keyStroke) {
        if (this.arrayTable != null) {
            this.arrayTable.remove(keyStroke);
        }
    }

    public void clear() {
        if (this.arrayTable != null) {
            this.arrayTable.clear();
        }
    }

    public KeyStroke[] keys() {
        if (this.arrayTable == null) {
            return null;
        }
        Object[] objectArray = new KeyStroke[this.arrayTable.size()];
        this.arrayTable.getKeys(objectArray);
        return objectArray;
    }

    public int size() {
        if (this.arrayTable == null) {
            return 0;
        }
        return this.arrayTable.size();
    }

    public KeyStroke[] allKeys() {
        int n = this.size();
        InputMap inputMap = this.getParent();
        if (n == 0) {
            if (inputMap != null) {
                return inputMap.allKeys();
            }
            return this.keys();
        }
        if (inputMap == null) {
            return this.keys();
        }
        KeyStroke[] keyStrokeArray = this.keys();
        KeyStroke[] keyStrokeArray2 = inputMap.allKeys();
        if (keyStrokeArray2 == null) {
            return keyStrokeArray;
        }
        if (keyStrokeArray == null) {
            return keyStrokeArray2;
        }
        HashMap hashMap = new HashMap();
        int n2 = keyStrokeArray.length - 1;
        while (n2 >= 0) {
            hashMap.put(keyStrokeArray[n2], keyStrokeArray[n2]);
            --n2;
        }
        n2 = keyStrokeArray2.length - 1;
        while (n2 >= 0) {
            hashMap.put(keyStrokeArray2[n2], keyStrokeArray2[n2]);
            --n2;
        }
        Object[] objectArray = new KeyStroke[hashMap.size()];
        return (KeyStroke[])hashMap.keySet().toArray(objectArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.defaultWriteObject();
        KeyStroke[] keyStrokeArray = this.keys();
        int n2 = 0;
        if (keyStrokeArray != null) {
            n = 0;
            while (n < keyStrokeArray.length) {
                Object object = this.get(keyStrokeArray[n]);
                if (object instanceof Serializable) {
                    ++n2;
                } else {
                    keyStrokeArray[n] = null;
                }
                ++n;
            }
        }
        objectOutputStream.writeInt(n2);
        n = 0;
        while (n2 > 0) {
            if (keyStrokeArray[n] != null) {
                objectOutputStream.writeObject(keyStrokeArray[n]);
                objectOutputStream.writeObject(this.get(keyStrokeArray[n]));
                --n2;
            }
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt() - 1;
        while (n >= 0) {
            this.put((KeyStroke)objectInputStream.readObject(), objectInputStream.readObject());
            --n;
        }
    }
}

