/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import sun.awt.font.NativeFontWrapper;
import sun.awt.image.BufferedImageGraphicsConfig;
import sun.awt.image.Image;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ShortComponentRaster;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.java2d.OutputManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.DrawBytes;
import sun.java2d.loops.DrawBytesRasterContext;
import sun.java2d.loops.DrawChars;
import sun.java2d.loops.DrawCharsRasterContext;
import sun.java2d.loops.DrawGlyphVector;
import sun.java2d.loops.DrawGlyphVectorRasterContext;
import sun.java2d.loops.DrawLine;
import sun.java2d.loops.DrawLineRasterContext;
import sun.java2d.loops.DrawPolygons;
import sun.java2d.loops.DrawPolygonsRasterContext;
import sun.java2d.loops.DrawRect;
import sun.java2d.loops.DrawRectRasterContext;
import sun.java2d.loops.DrawString;
import sun.java2d.loops.DrawStringRasterContext;
import sun.java2d.loops.FillPolygons;
import sun.java2d.loops.FillPolygonsRasterContext;
import sun.java2d.loops.FillRect;
import sun.java2d.loops.FillRectRasterContext;
import sun.java2d.loops.FillSpans;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.ImageData;
import sun.java2d.loops.LockableRaster;
import sun.java2d.loops.RasterLockingException;
import sun.java2d.loops.RasterOutputManager;
import sun.java2d.pipe.DuctusRenderer;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SimpleRenderPipe;
import sun.java2d.pipe.SpanIterator;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.TranslateablePipe;

public class BufferedImageGraphics2D
extends SunGraphics2D
implements SimpleRenderPipe,
PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe,
TranslateablePipe,
TextPipe {
    public BufferedImage bufImg;
    Component component;
    WritableRaster raster;
    private ImageData cachedID;
    private int primtype;
    Object drawLineState;
    DrawLineRasterContext dlrc;
    Object fillRectState;
    FillRectRasterContext frrc;
    FillSpanCachedState fillSpanState;
    Object drawRectState;
    DrawRectRasterContext drrc;
    Object drawPolysState;
    Object drawPolygonState;
    Object drawPolylineState;
    DrawPolygonsRasterContext dprc;
    Object fillPolysState;
    Object fillPolygonState;
    FillPolygonsRasterContext fprc;
    Object drawStringState;
    DrawStringRasterContext dsrc;
    Object drawGlyphVectorState;
    DrawGlyphVectorRasterContext gvrc;
    Object drawCharsState;
    DrawCharsRasterContext dcrc;
    Object drawBytesState;
    DrawBytesRasterContext dbrc;
    Font lastGlyphVectorFont;
    FillRectRasterContext crrc;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private int xOrigin;
    private int yOrigin;
    private Font cachedFont;
    private AffineTransform cachedTextTransform;
    private boolean textIsAntiAliased;
    private boolean textUsesFractionalMetrics;
    private boolean useFastTextClip;
    private float fastClipMinY;
    private float fastClipMaxY;
    private int cachedFontRotate;
    private int lastGlyphVectorFontRotate;
    private static final int slowTextTransformMask = 120;

    public BufferedImageGraphics2D(BufferedImage bufferedImage, Component component) {
        this.bufImg = bufferedImage;
        this.raster = bufferedImage.getRaster();
        this.component = component;
        this.setDevClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        if (this.component != null) {
            this.setColor(this.component.getForeground());
            this.setBackground(this.component.getBackground());
            this.setFont(this.component.getFont());
        } else {
            this.setColor(Color.white);
            this.setBackground(Color.black);
            this.setFont(new Font("Dialog", 0, 12));
        }
        this.primtype = bufferedImage.getType();
        if (this.primtype == 13 && bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            if (ImageData.isAllOpaqueGrayICM(indexColorModel) && indexColorModel.getPixelSize() == 8) {
                this.primtype = -17;
            }
        } else if (this.primtype == 0 && bufferedImage.getColorModel() instanceof IndexColorModel && this.raster.getNumBands() == 1 && this.raster instanceof ShortComponentRaster) {
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            ShortComponentRaster shortComponentRaster = (ShortComponentRaster)this.raster;
            if (shortComponentRaster.getPixelStride() == 1 && indexColorModel.getPixelSize() == 12 && ImageData.isAllOpaqueGrayICM(indexColorModel)) {
                this.primtype = -18;
            }
        }
        this.invalidateCachedState();
    }

    protected void invalidatePipe() {
        super.invalidatePipe();
        this.invalidateCachedState();
    }

    private void invalidateFontState() {
        this.drawStringState = null;
        this.dsrc = null;
        this.drawGlyphVectorState = null;
        this.gvrc = null;
        this.drawCharsState = null;
        this.dcrc = null;
        this.drawBytesState = null;
        this.dbrc = null;
        this.lastGlyphVectorFont = null;
        this.cachedFont = null;
        this.useFastTextClip = false;
    }

    private void invalidateCachedState() {
        this.drawLineState = null;
        this.dlrc = null;
        this.fillRectState = null;
        this.frrc = null;
        this.fillSpanState = null;
        this.drawRectState = null;
        this.drrc = null;
        this.drawPolysState = null;
        this.drawPolygonState = null;
        this.drawPolylineState = null;
        this.dprc = null;
        this.fillPolysState = null;
        this.fillPolygonState = null;
        this.fprc = null;
        this.crrc = null;
        Rectangle rectangle = this.getCompBounds();
        if (rectangle != null) {
            this.clipX = rectangle.x;
            this.clipY = rectangle.y;
            this.clipW = rectangle.width;
            this.clipH = rectangle.height;
        } else if (this.devClip != null) {
            this.clipX = this.devClip.x;
            this.clipY = this.devClip.y;
            this.clipW = this.devClip.width;
            this.clipH = this.devClip.height;
        }
        this.cachedID = null;
        this.invalidateFontState();
    }

    private void computeFontOptimizations(Font font) {
        if (this.cachedFont != font) {
            this.cachedFont = font;
            float f = font.getSize2D();
            FontRenderContext fontRenderContext = this.getFontRenderContext();
            this.cachedTextTransform = fontRenderContext.getTransform();
            this.cachedTextTransform.scale(f, f);
            this.cachedTextTransform.preConcatenate(font.getTransform());
            int n = this.cachedTextTransform.getType();
            this.cachedTextTransform.preConcatenate(this.transform);
            this.cachedFontRotate = -1;
            this.textIsAntiAliased = fontRenderContext.isAntiAliased();
            this.textUsesFractionalMetrics = fontRenderContext.usesFractionalMetrics();
            this.useFastTextClip = false;
            if (0 == (n & 0x78)) {
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n2 = fontMetrics.getHeight();
                Rectangle rectangle = this.getClipBounds();
                if (rectangle != null) {
                    this.fastClipMinY = rectangle.y - n2;
                    this.fastClipMaxY = rectangle.y + rectangle.height + n2;
                } else {
                    this.fastClipMinY = this.devClip.y - this.yOrigin - n2;
                    this.fastClipMaxY = this.devClip.y - this.yOrigin + this.devClip.height + n2;
                }
                this.useFastTextClip = true;
            }
        }
    }

    private boolean isRotated(AffineTransform affineTransform, double[] dArray) {
        affineTransform.getMatrix(dArray);
        return dArray[0] != dArray[3] || dArray[1] != 0.0 || dArray[2] != 0.0 || !(dArray[0] > 0.0);
    }

    public void setOrigin(int n, int n2) {
        this.xOrigin = n;
        this.yOrigin = n2;
    }

    public void setFont(Font font) {
        if (this.cachedFont != font) {
            super.setFont(font);
            this.invalidateFontState();
        }
    }

    public ColorModel getDeviceColorModel() {
        return this.bufImg.getColorModel();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        GraphicsConfiguration graphicsConfiguration;
        if (this.component != null && (graphicsConfiguration = this.component.getGraphicsConfiguration()) != null) {
            return graphicsConfiguration;
        }
        return BufferedImageGraphicsConfig.getConfig(this.bufImg);
    }

    public OutputManager getOutputManager() {
        return BufferedImageGraphicsConfig.getOutputManager(this.bufImg);
    }

    public void dispose() {
    }

    public void finalize() {
    }

    public boolean drawImage(java.awt.Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            super.drawImage(bufferedImage, n, n2, n3, n4, null, imageObserver);
            return true;
        }
        Image image2 = (Image)image;
        if (image2.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(this, image2, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (image instanceof BufferedImage) {
            super.drawImage((BufferedImage)image, n, n2, color, imageObserver);
            return true;
        }
        Image image2 = (Image)image;
        if (image2.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(this, image2, n, n2, color, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        if (image instanceof BufferedImage) {
            super.drawImage((BufferedImage)image, n, n2, n3, n4, color, imageObserver);
            return true;
        }
        Image image2 = (Image)image;
        if (image2.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(this, image2, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (n == n3 || n2 == n4) {
            return true;
        }
        if (n5 == n7 || n6 == n8) {
            return true;
        }
        if (image instanceof BufferedImage) {
            super.drawImage((BufferedImage)image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
            return true;
        }
        Image image2 = (Image)image;
        if (image2.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(this, image2, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (image instanceof BufferedImage) {
            super.drawImage((BufferedImage)image, affineTransform, 0, 0, null, imageObserver);
            return true;
        }
        Image image2 = (Image)image;
        if (image2.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(this, image2, affineTransform, imageObserver);
    }

    public boolean drawImage(java.awt.Image image, int n, int n2, ImageObserver imageObserver) {
        if (image instanceof BufferedImage) {
            return super.drawImage((BufferedImage)image, n, n2, null, imageObserver);
        }
        Image image2 = (Image)image;
        if (image2.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(this, image2, n, n2, null, imageObserver);
    }

    protected void checkCustomComposite() {
    }

    public void setPaint(Paint paint) {
        super.setPaint(paint);
        this.invalidateCachedState();
    }

    public void setBackground(Color color) {
        if (this.backgroundColor != color) {
            this.crrc = null;
            super.setBackground(color);
        }
    }

    public void setClip(int n, int n2, int n3, int n4) {
        super.setClip(n, n2, n3, n4);
        this.invalidateCachedState();
    }

    public void setClip(Shape shape) {
        super.setClip(shape);
        this.invalidateCachedState();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        super.clipRect(n, n2, n3, n4);
        this.invalidateCachedState();
    }

    public void clip(Shape shape) {
        super.clip(shape);
        this.invalidateCachedState();
    }

    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        n += this.xOrigin;
        n2 += this.yOrigin;
        n3 += this.xOrigin;
        n4 += this.yOrigin;
        if (this.dlrc == null) {
            LockableRaster lockableRaster = new LockableRaster(sunGraphics2D);
            int[] nArray = new int[]{lockableRaster.type};
            GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(DrawLine.getMethodSignature(), nArray, lockableRaster.devID);
            if (graphicsPrimitive != null) {
                DrawLine drawLine = (DrawLine)graphicsPrimitive;
                this.dlrc = drawLine.createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.clipX, this.clipY, this.clipW, this.clipH);
            }
        }
        if (this.dlrc != null) {
            this.dlrc.invoke(n, n2, n3, n4);
        } else {
            this.drawLineState = RasterOutputManager.getManager().drawLine(sunGraphics2D, n, n2, n3, n4, this.drawLineState);
        }
    }

    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        n += this.xOrigin;
        n2 += this.yOrigin;
        if (this.frrc == null) {
            LockableRaster lockableRaster = new LockableRaster(sunGraphics2D);
            int[] nArray = new int[]{lockableRaster.type};
            GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(FillRect.getMethodSignature(), nArray, lockableRaster.devID);
            if (graphicsPrimitive != null) {
                FillRect fillRect = (FillRect)graphicsPrimitive;
                this.frrc = fillRect.createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.clipX, this.clipY, this.clipW, this.clipH);
            }
        }
        if (this.frrc != null) {
            this.frrc.invoke(n, n2, n3, n4);
        } else {
            this.fillRectState = RasterOutputManager.getManager().fillRect(sunGraphics2D, n, n2, n3, n4, this.fillRectState);
        }
    }

    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator();
        try {
            shapeSpanIterator.setOutputArea(sunGraphics2D.getCompBounds());
            shapeSpanIterator.setRule(1);
            BasicStroke basicStroke = (BasicStroke)sunGraphics2D.stroke;
            AffineTransform affineTransform = sunGraphics2D.transformState == 2 ? sunGraphics2D.transform : null;
            PathConsumer pathConsumer = DuctusRenderer.createStroker(shapeSpanIterator, basicStroke, affineTransform);
            affineTransform = sunGraphics2D.transformState == 0 ? null : sunGraphics2D.transform;
            PathIterator pathIterator = shape.getPathIterator(affineTransform);
            try {
                boolean bl = sunGraphics2D.strokeHint != 2;
                DuctusRenderer.feedConsumer(pathIterator, pathConsumer, bl, 0.25f);
            }
            catch (PathException pathException) {
                throw new InternalError("Unable to Stroke shape (" + pathException.getMessage() + ")");
            }
            this.fillSpans(sunGraphics2D, shapeSpanIterator);
            Object var10_10 = null;
            shapeSpanIterator.dispose();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            shapeSpanIterator.dispose();
            throw throwable;
        }
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator();
        try {
            shapeSpanIterator.setOutputArea(sunGraphics2D.getCompBounds());
            AffineTransform affineTransform = sunGraphics2D.transformState == 0 ? null : sunGraphics2D.transform;
            shapeSpanIterator.appendPath(shape.getPathIterator(affineTransform));
            this.fillSpans(sunGraphics2D, shapeSpanIterator);
            Object var6_5 = null;
            shapeSpanIterator.dispose();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            shapeSpanIterator.dispose();
            throw throwable;
        }
    }

    public void fillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator) {
        Object object;
        int[] nArray;
        FillSpans fillSpans = null;
        LockableRaster lockableRaster = null;
        if (this.fillSpanState != null) {
            fillSpans = this.fillSpanState.fillSpanObj;
            lockableRaster = this.fillSpanState.lrDst;
        } else {
            lockableRaster = new LockableRaster(sunGraphics2D);
            nArray = new int[]{lockableRaster.type};
            object = GraphicsPrimitiveMgr.locate(FillSpans.getMethodSignature(), nArray, lockableRaster.devID);
            if (object != null) {
                this.fillSpanState = new FillSpanCachedState();
                this.fillSpanState.fillSpanObj = fillSpans = (FillSpans)object;
                this.fillSpanState.lrDst = lockableRaster;
            } else if (this.frrc == null && (object = GraphicsPrimitiveMgr.locate(FillRect.getMethodSignature(), nArray, lockableRaster.devID)) != null) {
                FillRect fillRect = (FillRect)object;
                this.frrc = fillRect.createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.clipX, this.clipY, this.clipW, this.clipH);
            }
        }
        nArray = new int[4];
        if (fillSpans != null) {
            spanIterator.getPathBox(nArray);
            try {
                try {
                    lockableRaster.lock(fillSpans.getLockFlags()[0], nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
                    fillSpans.FillSpans(lockableRaster.id, sunGraphics2D.getColor(), spanIterator);
                }
                catch (RasterLockingException rasterLockingException) {
                    Object var9_10 = null;
                    lockableRaster.unlock();
                }
                Object var9_9 = null;
                lockableRaster.unlock();
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                lockableRaster.unlock();
                throw throwable;
            }
            return;
        }
        object = RasterOutputManager.getManager();
        while (spanIterator.nextSpan(nArray)) {
            if (this.frrc != null) {
                this.frrc.invoke(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
                continue;
            }
            this.fillRectState = ((RasterOutputManager)object).fillRect(sunGraphics2D, nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1], this.fillRectState);
        }
    }

    private void translatePolys(int[][] nArray, int[] nArray2, int n) {
        int[] nArray3;
        int[] nArray4;
        int n2;
        int n3 = 0;
        if (nArray2 == null) {
            n3 = n;
        } else {
            n2 = 0;
            while (n2 < n) {
                n3 += nArray2[n2];
                ++n2;
            }
        }
        if (this.xOrigin != 0) {
            nArray4 = new int[n3];
            nArray3 = nArray[0];
            n2 = 0;
            while (n2 < n3) {
                nArray4[n2] = nArray3[n2] + this.xOrigin;
                ++n2;
            }
            nArray[0] = nArray4;
        }
        if (this.yOrigin != 0) {
            nArray4 = new int[n3];
            nArray3 = nArray[1];
            n2 = 0;
            while (n2 < n3) {
                nArray4[n2] = nArray3[n2] + this.yOrigin;
                ++n2;
            }
            nArray[1] = nArray4;
        }
    }

    public void drawPolys(SunGraphics2D sunGraphics2D, int[] object, int[] object2, int[] nArray, int n, boolean bl) {
        Object object3;
        if (this.xOrigin != 0 || this.yOrigin != 0) {
            object3 = new int[][]{object, object2};
            this.translatePolys((int[][])object3, nArray, n);
            object = object3[0];
            object2 = object3[1];
        }
        if (this.dprc == null) {
            object3 = new LockableRaster(sunGraphics2D);
            int[] nArray2 = new int[]{((LockableRaster)object3).type};
            GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(DrawPolygons.getMethodSignature(), nArray2, ((LockableRaster)object3).devID);
            if (graphicsPrimitive != null) {
                DrawPolygons drawPolygons = (DrawPolygons)graphicsPrimitive;
                this.dprc = drawPolygons.createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.clipX, this.clipY, this.clipW, this.clipH);
            }
        }
        if (this.dprc != null) {
            this.dprc.invoke((int[])object, (int[])object2, nArray, n, bl);
        } else {
            this.drawPolysState = RasterOutputManager.getManager().drawPolys(sunGraphics2D, (int[])object, (int[])object2, nArray, n, bl, this.drawPolysState);
        }
    }

    public void fillPolys(SunGraphics2D sunGraphics2D, int[] object, int[] object2, int[] nArray, int n, boolean bl) {
        Object object3;
        if (this.xOrigin != 0 || this.yOrigin != 0) {
            object3 = new int[][]{object, object2};
            this.translatePolys((int[][])object3, nArray, n);
            object = object3[0];
            object2 = object3[1];
        }
        if (this.fprc == null) {
            object3 = new LockableRaster(sunGraphics2D);
            int[] nArray2 = new int[]{((LockableRaster)object3).type};
            GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(FillPolygons.getMethodSignature(), nArray2, ((LockableRaster)object3).devID);
            if (graphicsPrimitive != null) {
                FillPolygons fillPolygons = (FillPolygons)graphicsPrimitive;
                this.fprc = fillPolygons.createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.clipX, this.clipY, this.clipW, this.clipH);
            }
        }
        if (this.fprc != null) {
            this.fprc.invoke((int[])object, (int[])object2, nArray, n, bl);
        } else {
            this.fillPolysState = RasterOutputManager.getManager().fillPolys(sunGraphics2D, (int[])object, (int[])object2, nArray, n, bl, this.fillPolysState);
        }
    }

    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        n += this.xOrigin;
        n2 += this.yOrigin;
        if (this.drrc == null) {
            LockableRaster lockableRaster = new LockableRaster(sunGraphics2D);
            int[] nArray = new int[]{lockableRaster.type};
            GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(DrawRect.getMethodSignature(), nArray, lockableRaster.devID);
            if (graphicsPrimitive != null) {
                DrawRect drawRect = (DrawRect)graphicsPrimitive;
                this.drrc = drawRect.createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.clipX, this.clipY, this.clipW, this.clipH);
            }
        }
        if (this.drrc != null) {
            this.drrc.invoke(n, n2, n3, n4);
        } else {
            this.drawRectState = RasterOutputManager.getManager().drawRect(sunGraphics2D, n, n2, n3, n4, this.drawRectState);
        }
    }

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.draw(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        sunGraphics2D.shapepipe.draw(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.draw(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] object, int[] object2, int n) {
        Object object3;
        if (this.xOrigin != 0 || this.yOrigin != 0) {
            object3 = new int[][]{object, object2};
            this.translatePolys((int[][])object3, null, n);
            object = object3[0];
            object2 = object3[1];
        }
        if (this.dprc == null) {
            object3 = new LockableRaster(sunGraphics2D);
            int[] nArray = new int[]{((LockableRaster)object3).type};
            GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(DrawPolygons.getMethodSignature(), nArray, ((LockableRaster)object3).devID);
            if (graphicsPrimitive != null) {
                DrawPolygons drawPolygons = (DrawPolygons)graphicsPrimitive;
                this.dprc = drawPolygons.createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.clipX, this.clipY, this.clipW, this.clipH);
            }
        }
        if (this.dprc != null) {
            object3 = new int[]{n};
            this.dprc.invoke((int[])object, (int[])object2, (int[])object3, 1, false);
        } else {
            this.drawPolylineState = RasterOutputManager.getManager().drawPolyline(sunGraphics2D, (int[])object, (int[])object2, n, this.drawPolylineState);
        }
    }

    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] object, int[] object2, int n) {
        Object object3;
        if (this.xOrigin != 0 || this.yOrigin != 0) {
            object3 = new int[][]{object, object2};
            this.translatePolys((int[][])object3, null, n);
            object = object3[0];
            object2 = object3[1];
        }
        if (this.dprc == null) {
            object3 = new LockableRaster(sunGraphics2D);
            int[] nArray = new int[]{((LockableRaster)object3).type};
            GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(DrawPolygons.getMethodSignature(), nArray, ((LockableRaster)object3).devID);
            if (graphicsPrimitive != null) {
                DrawPolygons drawPolygons = (DrawPolygons)graphicsPrimitive;
                this.dprc = drawPolygons.createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.clipX, this.clipY, this.clipW, this.clipH);
            }
        }
        if (this.dprc != null) {
            object3 = new int[]{n};
            this.dprc.invoke((int[])object, (int[])object2, (int[])object3, 1, true);
        } else {
            this.drawPolygonState = RasterOutputManager.getManager().drawPolygon(sunGraphics2D, (int[])object, (int[])object2, n, this.drawPolygonState);
        }
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.fill(sunGraphics2D, new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        sunGraphics2D.shapepipe.fill(sunGraphics2D, new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        sunGraphics2D.shapepipe.fill(sunGraphics2D, new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] object, int[] object2, int n) {
        Object object3;
        if (this.xOrigin != 0 || this.yOrigin != 0) {
            object3 = new int[][]{object, object2};
            this.translatePolys((int[][])object3, null, n);
            object = object3[0];
            object2 = object3[1];
        }
        if (this.fprc == null) {
            object3 = new LockableRaster(sunGraphics2D);
            int[] nArray = new int[]{((LockableRaster)object3).type};
            GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(FillPolygons.getMethodSignature(), nArray, ((LockableRaster)object3).devID);
            if (graphicsPrimitive != null) {
                FillPolygons fillPolygons = (FillPolygons)graphicsPrimitive;
                this.fprc = fillPolygons.createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.clipX, this.clipY, this.clipW, this.clipH);
            }
        }
        if (this.fprc != null) {
            object3 = new int[]{n};
            this.fprc.invoke((int[])object, (int[])object2, (int[])object3, 1, true);
        } else {
            this.fillPolygonState = RasterOutputManager.getManager().fillPolygon(sunGraphics2D, (int[])object, (int[])object2, n, this.fillPolygonState);
        }
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        if (this.fillpipe != this) {
            super.clearRect(n, n2, n3, n4);
            return;
        }
        if (this.crrc == null && this.clipState != 2) {
            LockableRaster lockableRaster = new LockableRaster(this);
            int[] nArray = new int[]{lockableRaster.type};
            GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(FillRect.getMethodSignature(), nArray, lockableRaster.devID);
            if (graphicsPrimitive != null) {
                FillRect fillRect = (FillRect)graphicsPrimitive;
                this.crrc = fillRect.createCachedContext(this.raster, this.bufImg.getColorModel(), this.getBackground(), this.clipX, this.clipY, this.clipW, this.clipH);
            }
        }
        if (this.crrc != null) {
            this.crrc.invoke(n += this.xOrigin, n2 += this.yOrigin, n3, n4);
        } else {
            super.clearRect(n, n2, n3, n4);
        }
    }

    public Object drawString(SunGraphics2D sunGraphics2D, String string, float f, float f2, Object object) {
        Object object2;
        if (this.dsrc == null) {
            object2 = new LockableRaster(this);
            int[] nArray = new int[]{((LockableRaster)object2).type};
            GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(DrawString.getMethodSignature(), nArray, ((LockableRaster)object2).devID);
            if (graphicsPrimitive != null) {
                Object object3;
                if (this.cachedFont == null) {
                    this.computeFontOptimizations(this.getFont());
                }
                boolean bl = true;
                double[] dArray = new double[6];
                if (this.isRotated(this.cachedTextTransform, dArray)) {
                    if (this.cachedFontRotate == -1) {
                        this.cachedFontRotate = NativeFontWrapper.fontCanRotate(this.cachedFont);
                    }
                    if (this.cachedFontRotate != 1) {
                        bl = false;
                        object3 = sunGraphics2D.getFontRenderContext();
                        if (this.cachedFontRotate == 2 && NativeFontWrapper.fontCanRotateText(sunGraphics2D.getFont(), string, dArray, ((FontRenderContext)object3).isAntiAliased(), ((FontRenderContext)object3).usesFractionalMetrics())) {
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    object3 = (DrawString)graphicsPrimitive;
                    this.dsrc = ((DrawString)object3).createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.cachedFont, this.cachedTextTransform, this.textIsAntiAliased, this.textUsesFractionalMetrics, this.clipX, this.clipY, this.clipW, this.clipH);
                }
            }
        }
        if (this.useFastTextClip && (f2 < this.fastClipMinY || f2 > this.fastClipMaxY)) {
            return null;
        }
        if (this.dsrc != null) {
            if (sunGraphics2D.transformState == 2) {
                object2 = new double[]{f, f2};
                sunGraphics2D.transform.deltaTransform((double[])object2, 0, (double[])object2, 0, 1);
                f = (float)object2[0];
                f2 = (float)object2[1];
            }
            this.dsrc.invoke(string, f, f2);
        } else {
            this.drawStringState = RasterOutputManager.getManager().drawString(sunGraphics2D, string, f, f2, this.drawStringState);
        }
        return null;
    }

    public Object drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2, Object object) {
        Object object2;
        Font font = glyphVector.getFont();
        if (font != this.lastGlyphVectorFont) {
            this.drawGlyphVectorState = null;
            this.gvrc = null;
            this.lastGlyphVectorFont = font;
            this.lastGlyphVectorFontRotate = -1;
        }
        if (this.gvrc == null) {
            object2 = new LockableRaster(this);
            int[] nArray = new int[]{((LockableRaster)object2).type};
            GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(DrawGlyphVector.getMethodSignature(), nArray, ((LockableRaster)object2).devID);
            if (graphicsPrimitive != null) {
                float f3 = font.getSize2D();
                FontRenderContext fontRenderContext = glyphVector.getFontRenderContext();
                AffineTransform affineTransform = fontRenderContext.getTransform();
                affineTransform.scale(f3, f3);
                affineTransform.preConcatenate(font.getTransform());
                affineTransform.preConcatenate(this.transform);
                boolean bl = true;
                double[] dArray = new double[6];
                if (this.isRotated(affineTransform, dArray)) {
                    if (this.lastGlyphVectorFontRotate == -1) {
                        this.lastGlyphVectorFontRotate = NativeFontWrapper.fontCanRotate(font);
                    }
                    if (this.lastGlyphVectorFontRotate != 1) {
                        bl = false;
                        if (this.lastGlyphVectorFontRotate == 2 && NativeFontWrapper.fontCanRotateGlyphVector(font, glyphVector.getGlyphCodes(0, glyphVector.getNumGlyphs(), null), dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics())) {
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    DrawGlyphVector drawGlyphVector = (DrawGlyphVector)graphicsPrimitive;
                    this.gvrc = drawGlyphVector.createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), font, affineTransform, this.transform, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this.clipX, this.clipY, this.clipW, this.clipH);
                }
            }
        }
        if (this.gvrc != null) {
            if (sunGraphics2D.transformState == 2) {
                object2 = new double[]{f, f2};
                sunGraphics2D.transform.deltaTransform((double[])object2, 0, (double[])object2, 0, 1);
                f = (float)object2[0];
                f2 = (float)object2[1];
            }
            this.gvrc.invoke(glyphVector, f, f2);
        } else {
            this.drawGlyphVectorState = RasterOutputManager.getManager().drawGlyphVector(sunGraphics2D, glyphVector, f, f2, this.drawGlyphVectorState);
        }
        return null;
    }

    public Object drawChars(SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, int n3, int n4, Object object) {
        Object object2;
        if (this.dcrc == null) {
            LockableRaster lockableRaster = new LockableRaster(this);
            int[] nArray = new int[]{lockableRaster.type};
            object2 = GraphicsPrimitiveMgr.locate(DrawChars.getMethodSignature(), nArray, lockableRaster.devID);
            if (object2 != null) {
                Object object3;
                if (this.cachedFont == null) {
                    this.computeFontOptimizations(this.getFont());
                }
                boolean bl = true;
                double[] dArray = new double[6];
                if (this.isRotated(this.cachedTextTransform, dArray)) {
                    if (this.cachedFontRotate == -1) {
                        this.cachedFontRotate = NativeFontWrapper.fontCanRotate(this.cachedFont);
                    }
                    if (this.cachedFontRotate != 1) {
                        bl = false;
                        object3 = sunGraphics2D.getFontRenderContext();
                        if (this.cachedFontRotate == 2 && NativeFontWrapper.fontCanRotateText(sunGraphics2D.getFont(), new String(cArray, n, n2), dArray, ((FontRenderContext)object3).isAntiAliased(), ((FontRenderContext)object3).usesFractionalMetrics())) {
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    object3 = (DrawChars)object2;
                    this.dcrc = ((DrawChars)object3).createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.cachedFont, this.cachedTextTransform, this.textIsAntiAliased, this.textUsesFractionalMetrics, this.clipX, this.clipY, this.clipW, this.clipH);
                }
            }
        }
        if (this.useFastTextClip && ((float)n4 < this.fastClipMinY || (float)n4 > this.fastClipMaxY)) {
            return null;
        }
        if (this.dcrc != null) {
            float f;
            float f2;
            if (sunGraphics2D.transformState == 2) {
                object2 = new double[]{n3, n4};
                sunGraphics2D.transform.deltaTransform((double[])object2, 0, (double[])object2, 0, 1);
                f2 = (float)object2[0];
                f = (float)object2[1];
            } else {
                f2 = n3;
                f = n4;
            }
            this.dcrc.invoke(cArray, n, n2, f2, f);
        } else {
            this.drawCharsState = RasterOutputManager.getManager().drawChars(sunGraphics2D, cArray, n, n2, n3, n4, this.drawCharsState);
        }
        return null;
    }

    public Object drawBytes(SunGraphics2D sunGraphics2D, byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        Object object2;
        if (this.dbrc == null) {
            LockableRaster lockableRaster = new LockableRaster(this);
            int[] nArray = new int[]{lockableRaster.type};
            object2 = GraphicsPrimitiveMgr.locate(DrawBytes.getMethodSignature(), nArray, lockableRaster.devID);
            if (object2 != null) {
                Object object3;
                if (this.cachedFont == null) {
                    this.computeFontOptimizations(this.getFont());
                }
                boolean bl = true;
                double[] dArray = new double[6];
                if (this.isRotated(this.cachedTextTransform, dArray)) {
                    if (this.cachedFontRotate == -1) {
                        this.cachedFontRotate = NativeFontWrapper.fontCanRotate(this.cachedFont);
                    }
                    if (this.cachedFontRotate != 1) {
                        bl = false;
                        object3 = sunGraphics2D.getFontRenderContext();
                        if (this.cachedFontRotate == 2 && NativeFontWrapper.fontCanRotateText(sunGraphics2D.getFont(), new String(byArray, 0, n, n2), dArray, ((FontRenderContext)object3).isAntiAliased(), ((FontRenderContext)object3).usesFractionalMetrics())) {
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    object3 = (DrawBytes)object2;
                    this.dbrc = ((DrawBytes)object3).createCachedContext(this.raster, this.bufImg.getColorModel(), this.getColor(), this.cachedFont, this.cachedTextTransform, this.textIsAntiAliased, this.textUsesFractionalMetrics, this.clipX, this.clipY, this.clipW, this.clipH);
                }
            }
        }
        if (this.useFastTextClip && ((float)n4 < this.fastClipMinY || (float)n4 > this.fastClipMaxY)) {
            return null;
        }
        if (this.dbrc != null) {
            float f;
            float f2;
            if (sunGraphics2D.transformState == 2) {
                object2 = new double[]{n3, n4};
                sunGraphics2D.transform.deltaTransform((double[])object2, 0, (double[])object2, 0, 1);
                f2 = (float)object2[0];
                f = (float)object2[1];
            } else {
                f2 = n3;
                f = n4;
            }
            this.dbrc.invoke(byArray, n, n2, f2, f);
        } else {
            this.drawBytesState = RasterOutputManager.getManager().drawBytes(sunGraphics2D, byArray, n, n2, n3, n4, this.drawBytesState);
        }
        return null;
    }

    public ImageData lock(int n, int n2, int n3, int n4, int n5) {
        ImageData imageData = this.cachedID;
        if (null == imageData || imageData.amILocked()) {
            imageData = new ImageData();
        }
        imageData.setViewArea(n, n2, n3, n4);
        imageData.setLockMethod(n5);
        if (1 == this.lock(imageData)) {
            this.cachedID = imageData;
            return imageData;
        }
        return null;
    }

    private int lock(ImageData imageData) {
        if (null != imageData) {
            if (imageData.amILocked()) {
                return 7;
            }
            if (!imageData.equals(this.cachedID) && !LockableRaster.prepareImageData(imageData, this.raster, this.bufImg.getColorModel(), this.primtype)) {
                return 5;
            }
            if (LockableRaster.prepareRasterBounds(imageData, this.clipX, this.clipY, this.clipW, this.clipH)) {
                imageData.incLockCount();
                this.cachedID = imageData;
                return 1;
            }
        }
        return 5;
    }

    public int unlock(ImageData imageData) {
        int n = 5;
        WritableRaster writableRaster = this.raster;
        n = 6;
        if (null != imageData && imageData.amILocked()) {
            imageData.decLockCount();
        }
        return n;
    }

    public String toString() {
        String string = "BufferedImageGraphics2D[";
        string = string + "BufferedImage[" + this.bufImg + "]";
        string = string + " Component[" + this.component + "]";
        return string;
    }

    private static class FillSpanCachedState {
        FillSpans fillSpanObj;
        LockableRaster lrDst;

        private FillSpanCachedState() {
        }
    }
}

