/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeNumber
extends ScriptableObject {
    private static final int MAX_PRECISION = 100;
    private static final double defaultValue = 0.0;
    private double doubleValue;

    public NativeNumber() {
        this.doubleValue = 0.0;
    }

    public NativeNumber(double d) {
        this.doubleValue = d;
    }

    public static void finishInit(Scriptable scriptable, FunctionObject functionObject, Scriptable scriptable2) {
        int n = 7;
        String[] stringArray = new String[]{"NaN", "POSITIVE_INFINITY", "NEGATIVE_INFINITY", "MAX_VALUE", "MIN_VALUE"};
        double[] dArray = new double[]{ScriptRuntime.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.MAX_VALUE, Double.MIN_VALUE};
        int n2 = 0;
        while (n2 < stringArray.length) {
            functionObject.defineProperty(stringArray[n2], new Double(dArray[n2]), 7);
            ++n2;
        }
    }

    public String getClassName() {
        return "Number";
    }

    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        double d;
        double d2 = d = objectArray.length >= 1 ? ScriptRuntime.toNumber(objectArray[0]) : 0.0;
        if (bl) {
            return new NativeNumber(d);
        }
        return new Double(d);
    }

    public String jsFunction_toExponential(Object object) {
        return this.num_to(object, 1, 3, 0, 100, 1);
    }

    public String jsFunction_toFixed(Object object) {
        return this.num_to(object, 2, 2, -20, 100, 0);
    }

    public String jsFunction_toLocaleString(Object object) {
        return this.toString();
    }

    public String jsFunction_toPrecision(Object object) {
        return this.num_to(object, 0, 4, 1, 100, 0);
    }

    public String jsFunction_toString(Object object) {
        int n = object == Undefined.instance ? 10 : ScriptRuntime.toInt32(object);
        return ScriptRuntime.numberToString(this.doubleValue, n);
    }

    public double jsFunction_valueOf() {
        return this.doubleValue;
    }

    private String num_to(Object object, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (object == Undefined.instance) {
            n6 = 0;
            n2 = n;
        } else {
            n6 = ScriptRuntime.toInt32(object);
            if (n6 < n3 || n6 > n4) {
                Object[] objectArray = new Object[]{Integer.toString(n6)};
                throw NativeGlobal.constructError(Context.getCurrentContext(), "RangeError", ScriptRuntime.getMessage("msg.bad.precision", objectArray), this);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        DToA.JS_dtostr(stringBuffer, n2, n6 + n5, this.doubleValue);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.jsFunction_toString(Undefined.instance);
    }
}

