/* micro s5-like simulator
   (c) 1998 Peter Sieg
   usage: s5 filename [<debug_level>]
   debug_level not defined = 0;
   debug_level = 0 = no output
                 1 = only info at first aw
                 2 = info at every aw
                 3 = like 2 plus loading of awl
*/
#include <stdio.h> 
#include <conio.h>
#include <string.h>

/* prototypes */
void get_time(void);
int pow2(int);
void in_out(void);
void init(void);
void print_info(void);
void run_awl(void);
void step_aw(int);
void load(void);

#define MAXINT 32767
#define MAXAWL 100
#define MAXEAMTZ 2
#define MYPORT 0x3bc

/* used for loops etc. */
int n1,n2,debug,port;

/* hold boolean results 0 = false, 1 = true */
int b_vka,b_vkb,b_vkl,b_vku;

/* hold awl, max 100 aw's */
char s_operation[MAXAWL][5];
char s_operand[MAXAWL][5];
int i_baustein[MAXAWL];
int i_bitnr[MAXAWL];
char filename[256];

/* global message buffer */
char msg[256];

/* holds actual anweisung and total count of anweisungen */
int anz_aw,act_aw;

/* array for E/A/M/T/Z - only 0,0-7 is used so far */
int e[MAXEAMTZ][8], a[MAXEAMTZ][8], m[MAXEAMTZ][8], t[MAXEAMTZ][8], z[MAXEAMTZ][8];

/* holds accu */
int accu;

/* holds date (yy=year,yn=month,yd=day) and time (yh=hour,ym=minute,ys=second) */
/* yw = week of year (not implemented yet); yo day Of week 0-6 */
/* attention: year is only 2 digits! (millenium change) */
int yy,yn,yw,yd,yo,yh,ym,ys;


void get_time()
{
  int month,year,jhd;
  char buf[10];

  _tzset(); /* set time zone */

  _strdate(buf); /* VC4 mm/dd/yy */
/*dates(buf); =pcc */
/*strcpy(buf,"12-26-63"); =dummy */
/*printf("%s\n",buf);/* =debug */
  sscanf(buf,"%d/%d/%d",&yn,&yd,&yy); /* month-day-year(2-digits-only) */
/*printf("%d=%d=%d\n",yn,yd,yy);/* =debug */

  _strtime(buf); /* VC4 HH:MM:SS */
/*times(buf);=pcc */
/*strcpy(buf,"01:02:03"); =dummy */
/*printf("%s\n",buf);/* =debug */
  sscanf(buf,"%d:%d:%d",&yh,&ym,&ys); /* hour:minute:second */
/*printf("%d=%d=%d\n",yh,ym,ys);/* =debug */

/* now calc day of week with zeller algorythmus */
  year = yy;
  month= yn;
  if (year < 98) year = year + 2000; /* millenium hack */
  else year = year + 1900;
  if (month > 2) month -= 2;
  else
  {
    month += 10;
    year--;
  }
  jhd = year / 100;
  year %= 100;
  yo = (year / 4 + jhd / 4 + (13 * month-1) / 5 + yd + year - 2 * jhd) % 7;
  if (yo < 0) yo += 7;
/* now calc week of year - not correct, but simple substitution! */
  yw = (((yn - 1) * 30 + yd) / 7) + 1; /* (--month * 30 (days) + days) / 7 + 1*/
}


/* input e[0][0-7] from and output a[0][0-7] to printer port */
int pow2(i)
int i;
{
  int n = 1;
  int j;
  for (j=0; j<i; j++)
    n = n * 2;
  return n;
}

void in_out()
{
  char c;
  int  i;
  if (port != 0)
  {
/* output */
  i = 0;
  for (n1=0; n1<=7; n1++)
  {
    i = i + (a[0][n1] * pow2(n1)); /* assume a[0][*] can only be 0 or 1! */
/*  printf("n1=%d/i=%d/pow2(n1)=%d\n",n1,i,pow2(n1)); */
  }
  c = i;
/*printf("i=%d/c=%d/c=%c\n",i,c,c); */
  my_outp(port,c);

/* input  */
  c = (my_inp(port+1) >> 4);
  c = 0;
  for (n1=7; n1>=0; n1--)
  {
    if (c>=pow2(n1)) 
    {
      e[0][n1] = 1;  
      c = c - pow2(n1);
    }
    else e[0][n1] = 0;
/*  printf("c=%d/pow2(n1)=%d/e[0][n1]=%d\n",c,pow2(n1),e[0][n1]); */
  }
/* debug 
  for (n1=0; n1<=7; n1++)
    printf("e[0][%d]=%d\n",n1,e[0][n1]);
*/
  } // if (port != 0)
}

void init()
{
  int i,j;
  for (i=0; i<=(MAXEAMTZ-1); i++)
    for (j=0; j<=7; j++)
    {
      e[i][j]=0; a[i][j]=0; m[i][j]=0; t[i][j]=0; z[i][j]=0;
    }

  accu  = 0;

  b_vku = 1;
  b_vkl = 1;
  b_vka = 0;
  b_vkb = 0;

  act_aw= 1;
}

void print_info()
{
  /* int i; */
  char s[256];
  if (act_aw == anz_aw) sprintf(msg,"%3d: %2s ",act_aw,s_operation[act_aw]);
  else
  {
  sprintf(msg,"%3d: %2s %2s %2d.%d  ",act_aw,s_operation[act_aw],s_operand[act_aw]
         ,i_baustein[act_aw],i_bitnr[act_aw]);
  
  sprintf(s,"[%3d|",accu);
  strcat(msg,s);
  sprintf(s,"%3d|",t[0][0]);
  strcat(msg,s);
  sprintf(s,"%3d] ",z[0][0]);
  strcat(msg,s);
  sprintf(s,"V%1d%1d%1d%1d  ",b_vku,b_vkl,b_vka,b_vkb);

  strcat(msg,s);
  sprintf(s,"E%1d%1d%1d%1d%1d%1d%1d%1d  ",e[0][0],e[0][1],e[0][2],e[0][3],e[0][4],e[0][5],e[0][6],e[0][7]);
  strcat(msg,s);
  sprintf(s,"A%1d%1d%1d%1d%1d%1d%1d%1d  ",a[0][0],a[0][1],a[0][2],a[0][3],a[0][4],a[0][5],a[0][6],a[0][7]);
  strcat(msg,s);
  sprintf(s,"M%1d%1d%1d%1d%1d%1d%1d%1d  ",m[0][0],m[0][1],m[0][2],m[0][3],m[0][4],m[0][5],m[0][6],m[0][7]);
  strcat(msg,s);
  }
/*  
  i = getchar();  /* simple toggle for e[0][i] if i = 0-7 
  i = i - 48; /* char 0=ascii(48) 
  if ((i >= 0) && (i <= 7)) 
  {
    if  (e[0][i] == 0) e[0][i] = 1; 
    else e[0][i] = 0;
  }
*/
}

void step_awl()
{
  if (anz_aw >= 1)
  {
      step_aw(act_aw);

      if  (debug >= 2) print_info();
      if ((debug == 1) && (act_aw == 1)) print_info();

      act_aw++;
      if (act_aw > anz_aw)
      {
        act_aw=1;
        in_out();   /* output a[0][0-7] to port and get e[0][0-7] from port+1 */
        get_time(); /* update vars yh,ym,ys with current time */
      }
  }
}

void step_aw(i)
int i; 
{
/* first update b_vka = status of e,a,m,t,z [baustein][bitnr] */
/* for yh,ym,ys:b_vka = true if yh,ym,ys if greater than baustein */
  b_vka=0;
  if (strcmp(s_operand[i],"E") == 0) b_vka=e[i_baustein[i]][i_bitnr[i]];
  if (strcmp(s_operand[i],"A") == 0) b_vka=a[i_baustein[i]][i_bitnr[i]];
  if (strcmp(s_operand[i],"M") == 0) b_vka=m[i_baustein[i]][i_bitnr[i]];
  if (strcmp(s_operand[i],"T") == 0) if (t[i_baustein[i]][i_bitnr[i]] == 0) b_vka = 1;
  if (strcmp(s_operand[i],"Z") == 0) if (z[i_baustein[i]][i_bitnr[i]] == 0) b_vka = 1;
  if (strcmp(s_operand[i],"YY")== 0) if (yy > i_baustein[i]) b_vka = 1;
  if (strcmp(s_operand[i],"YN")== 0) if (yn > i_baustein[i]) b_vka = 1;
  if (strcmp(s_operand[i],"YW")== 0) if (yw > i_baustein[i]) b_vka = 1;
  if (strcmp(s_operand[i],"YD")== 0) if (yd > i_baustein[i]) b_vka = 1;
  if (strcmp(s_operand[i],"YO")== 0) if (yo > i_baustein[i]) b_vka = 1;
  if (strcmp(s_operand[i],"YH")== 0) if (yh > i_baustein[i]) b_vka = 1;
  if (strcmp(s_operand[i],"YM")== 0) if (ym > i_baustein[i]) b_vka = 1;
  if (strcmp(s_operand[i],"YS")== 0) if (ys > i_baustein[i]) b_vka = 1;

/* second update b_vkb */
  b_vkb=0;
  if (strcmp(s_operation[i],"U" ) == 0)
    if ((b_vka == 1) && ((b_vkl == 1) || (b_vku == 1))) b_vkb=1;

  if (strcmp(s_operation[i],"UN") == 0)
    if ((b_vka == 0) && ((b_vkl == 1) || (b_vku == 1))) b_vkb=1;

  if (strcmp(s_operation[i],"O" ) == 0)
    if ((b_vka == 1) || ((b_vkl == 1) || (b_vku == 1))) b_vkb=1;

  if (strcmp(s_operation[i],"ON") == 0)
    if ((b_vka == 1) || ((b_vkl == 1) || (b_vku == 1))) b_vkb=1;

/* now set operand to the value of b_vkl */
  if (strcmp(s_operation[i],"=" ) == 0)
  {
    if (strcmp(s_operand[i],"E") == 0) e[i_baustein[i]][i_bitnr[i]] = b_vkl;
    if (strcmp(s_operand[i],"A") == 0) a[i_baustein[i]][i_bitnr[i]] = b_vkl;
    if (strcmp(s_operand[i],"M") == 0) m[i_baustein[i]][i_bitnr[i]] = b_vkl;
    b_vkb = 1; /* allow b_vkl to be set to 1! */
/*  b_vkb = b_vkl; /* allow storing to next b_vkl! <-- wrong! */
  }

/* if b_vkl == 1 then load constant into accu with L K <value> <bitnr=ignored> */
  if (b_vkl == 1)
  {
    if (strcmp(s_operation[i],"L" ) == 0)
    {
      if (strcmp(s_operand[i],"K" ) == 0)
      {
        accu = i_baustein[i];
        b_vkb= 1; /* allow b_vkl to be set to 1! */
      } 
    }
  } 

/* operations S = Set T/Z to value of accu and R = Reset T/Z to 0 */
/* + second: S = Set E/A/M permanent or R = Reset E/A/M permanent */
  if (b_vkl == 1)
  {
    if (strcmp(s_operation[i],"R" ) == 0)
    {
      if (strcmp(s_operand[i],"T" ) == 0)
      {
        t[i_baustein[i]][i_bitnr[i]] = 0;
        b_vkb = 1; /* allow b_vkl to be set to 1! */
      } 
      if (strcmp(s_operand[i],"Z" ) == 0)
      {
        z[i_baustein[i]][i_bitnr[i]] = 0;
        b_vkb = 1; /* allow b_vkl to be set to 1! */
      } 
      if (strcmp(s_operand[i],"E" ) == 0)
      {
        e[i_baustein[i]][i_bitnr[i]] = 0;
        b_vkb = 1; /* allow b_vkl to be set to 1! */
      } 
      if (strcmp(s_operand[i],"A" ) == 0)
      {
        a[i_baustein[i]][i_bitnr[i]] = 0;
        b_vkb = 1; /* allow b_vkl to be set to 1! */
      } 
      if (strcmp(s_operand[i],"M" ) == 0)
      {
        m[i_baustein[i]][i_bitnr[i]] = 0;
        b_vkb = 1; /* allow b_vkl to be set to 1! */
      } 
    }
    if (strcmp(s_operation[i],"S" ) == 0)
    {
      if (strcmp(s_operand[i],"T" ) == 0)
      {
        t[i_baustein[i]][i_bitnr[i]] = accu;
        b_vkb = 1; /* allow b_vkl to be set to 1! */
      } 
      if (strcmp(s_operand[i],"Z" ) == 0)
      {
        z[i_baustein[i]][i_bitnr[i]] = accu;
        b_vkb = 1; /* allow b_vkl to be set to 1! */
      } 
      if (strcmp(s_operand[i],"E" ) == 0)
      {
        e[i_baustein[i]][i_bitnr[i]] = 1;
        b_vkb = 1; /* allow b_vkl to be set to 1! */
      } 
      if (strcmp(s_operand[i],"A" ) == 0)
      {
        a[i_baustein[i]][i_bitnr[i]] = 1;
        b_vkb = 1; /* allow b_vkl to be set to 1! */
      } 
      if (strcmp(s_operand[i],"M" ) == 0)
      {
        m[i_baustein[i]][i_bitnr[i]] = 1;
        b_vkb = 1; /* allow b_vkl to be set to 1! */
      } 
    }
  }


/* Z = count Z -> V = +1 if < MAXINT and R = -1 if > 0 */
  if (b_vkl == 1)
  {
    if (strcmp(s_operation[i],"Z" ) == 0)
    {
      if (strcmp(s_operand[i],"V" ) == 0)
      {
        if (z[i_baustein[i]][i_bitnr[i]] < MAXINT) z[i_baustein[i]][i_bitnr[i]]++; 
        b_vkb= 1; /* allow b_vkl to be set to 1! */
      } 
      if (strcmp(s_operand[i],"R" ) == 0)
      {
        if (z[i_baustein[i]][i_bitnr[i]] > 0) z[i_baustein[i]][i_bitnr[i]]--; 
        b_vkb= 1; /* allow b_vkl to be set to 1! */
      } 
    }
  } 

/* now store last b_vkb in b_vkl */
b_vkl = b_vkb;

/* set b_vku = 1 if s_operation = "U" || "UN" */
  if ((strcmp(s_operation[i],"U") == 0) || (strcmp(s_operation[i],"UN") == 0))
    b_vku = 1;
  else
    b_vku = 0;

/* if "BE" set b_vkl + b_vku = 1 */
  if (strcmp(s_operation[i],"BE") == 0)
  {
    b_vku = 1;
    b_vkl = 1;

/* update t[*][*] to -1 if > 0 => Pseudo timer */
    for (n1=0; n1<=(MAXEAMTZ-1); n1++) /* dont forget -1 or z[0] will also count down! */
      for (n2=0; n2<=7; n2++) 
        if (t[n1][n2] > 0) t[n1][n2]--;

  }
}

void load()
{
  FILE *fd;
  char buf[256],s1[5],s2[5];
  int i1,i2;
  int istop;

  debug = 2;

  if ((fd=fopen(filename,"r")) == NULL)
  {
	  sprintf(msg,"Cannot open AWL file: %s",filename);
      return;
  }

/* here file is open to read in awl */
  anz_aw=0;
  act_aw=1;
  istop=0;

  while ((istop == 0) && (fgets(buf,256,fd) != NULL))
  {
    anz_aw++;
    sscanf(buf,"%s %s %d %d",&s1,&s2,&i1,&i2);
/* debug only 
    if (debug == 3)
    {
      printf("%3d --> %s %s %d %d\n",anz_aw,s1,s2,i1,i2); 
      getchar(); 
    }
*/

/* only read up to MAXAWL lines or until BE */
    if ((anz_aw >= MAXAWL) || (strcmp(s1,"BE") == 0))
    {
      istop=1;
      strcpy(s1,"BE");
    }

/* syntax check here */
    if ((i2 < 0) || (i2 > 7)) /* bitnr must be between 0 and 7 */
    {
      sprintf(msg,"%s\nError in AWL file %s at line %d - wrong bitnr. Must be 0-7.",buf,filename,anz_aw);
      return;
    }
    if (i1 < 0)
    {
      sprintf(msg,"%s\nError in AWL file %s at line %d - segment negative.",buf,filename,anz_aw);
      return;
    }
    if (i1 >= MAXEAMTZ)
    {
      if ((strcmp(s2,"E") == 0) ||
          (strcmp(s2,"A") == 0) ||
          (strcmp(s2,"M") == 0) ||
          (strcmp(s2,"T") == 0) ||
          (strcmp(s2,"Z") == 0))
      {
      sprintf(msg,"%s\nError in AWL file %s at line %d - segment over max=%d.",buf,filename,anz_aw,MAXEAMTZ-1);
      return;
      }

    }

/* store aw in awl array */
    strcpy(s_operation[anz_aw],s1);
    strcpy(s_operand[anz_aw],s2);
    i_baustein[anz_aw]=i1;
    i_bitnr[anz_aw]=i2;

/* debug only 
    if (debug == 3)
    {
      printf("%3d ==> %s %s %d %d\n",anz_aw,s_operation[anz_aw],s_operand[anz_aw],i_baustein[anz_aw],i_bitnr[anz_aw]);
      getchar(); 
    }
*/

  }
  fclose(fd);

/* debug only
  if (debug == 3)
  {
    printf("==> anz_aw = %d\n",anz_aw);
    for (i1=1; i1<=anz_aw; i1++)
    {
      printf("%3d ==> %s %s %d %d\n",i1,s_operation[i1],s_operand[i1],i_baustein[i1],i_bitnr[i1]);
      getchar(); 
    }
  }
*/
  
/* show successful loading in msg buffer */
  sprintf(msg,"AWL file %s successfully loaded with %d aw's.",filename,anz_aw);

/* init variable e,a,m,z,t */
  init();

}



