/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.Choice;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class ColorList {
    static ColorModel colorModel = null;
    static final int MAXCOL = 40;
    static String[] nom = new String[]{"control", "controlText", "window", "windowText", "black", "blue", "green", "cyan", "red", "magenta", "brown", "lightGray", "gray", "lightBlue", "lightGreen", "lightCyan", "lightRed", "lightMagenta", "yellow", "white", "orange", "pink", "sepia", "slate", "slateLight", "aubergine", "pumpkin", "sand", "sandLight", "picea", "piceaLight", "lilac", "user"};
    static byte[] r = new byte[40];
    static byte[] g = new byte[40];
    static byte[] b = new byte[40];
    static Color[] couleur = new Color[]{SystemColor.control, SystemColor.controlText, SystemColor.window, SystemColor.windowText, Color.black, new Color(0, 0, 164), new Color(0, 164, 0), Color.cyan.darker(), new Color(164, 0, 0), new Color(164, 0, 164), new Color(160, 128, 64), Color.lightGray, Color.gray, Color.blue, Color.green, Color.cyan, Color.red, Color.magenta, Color.yellow, Color.white, Color.orange, Color.pink, new Color(192, 192, 128), new Color(160, 184, 200), new Color(168, 200, 224), new Color(144, 176, 168), new Color(240, 216, 160), new Color(216, 208, 184), new Color(224, 224, 208), new Color(160, 200, 168), new Color(168, 224, 184), new Color(176, 168, 216), new Color(195, 195, 195)};

    public ColorList() {
        for (int i = 0; i < couleur.length; ++i) {
            ColorList.setComponents(i);
        }
        ColorList.setModel();
    }

    static void setModel() {
        colorModel = new IndexColorModel(8, r.length, r, g, b);
    }

    static void setComponents(int n) {
        int n2 = couleur[n].getRGB();
        ColorList.r[n] = (byte)(n2 >> 16 & 0xFF);
        ColorList.g[n] = (byte)(n2 >> 8 & 0xFF);
        ColorList.b[n] = (byte)(n2 & 0xFF);
    }

    public static int Size() {
        return nom.length;
    }

    public static String GetString(int n) {
        return nom[n];
    }

    public static String[] ChoiceList() {
        return nom;
    }

    static Color getColor(int n) {
        if (colorModel == null) {
            ColorList.setModel();
        }
        int n2 = colorModel.getRed(n);
        int n3 = colorModel.getGreen(n);
        int n4 = colorModel.getBlue(n);
        return new Color(n2, n3, n4);
    }

    public static Color getColor(String string) {
        for (int i = 0; i < nom.length; ++i) {
            if (!nom[i].equalsIgnoreCase(string)) continue;
            return ColorList.getColor(i);
        }
        return Color.lightGray;
    }

    public static void fillChoice(Choice choice) {
        for (int i = 0; i < nom.length; ++i) {
            choice.add(nom[i]);
        }
    }

    public static int getIndex(String string) {
        for (int i = 0; i < nom.length; ++i) {
            if (!nom[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public static void changeColor(int n, Color color) {
        if (n >= 0 && n < couleur.length) {
            ColorList.couleur[n] = color;
            ColorList.setComponents(n);
            ColorList.setModel();
        } else {
            System.out.println("Bad color index ".concat(String.valueOf(String.valueOf(n))));
        }
    }

    public static void changeColor(String string, Color color) {
        ColorList.changeColor(ColorList.getIndex(string), color);
    }

    public static String getName(Color color) {
        int n = color.getRGB();
        for (int i = 0; i < couleur.length; ++i) {
            if (i >= nom.length || n != couleur[i].getRGB()) continue;
            return nom[i];
        }
        return "LightGray";
    }
}

