/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Path;
import common.Preferences;
import common.VectorString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Outline {
    int width;
    int height;
    FileWriter fw;
    BufferedWriter bw;
    static String g = "\"";
    public String htmlFile = "";
    public String htmlName = "";
    public String htmlDir = "";
    String path;
    String name;
    VectorString title;
    VectorString lines;
    VectorString body;
    VectorString summary;
    static final int TEXT = 16;
    static final int INDENT0 = 0;
    static final int INDENT1 = 1;
    static final int INDENT2 = 2;
    static final int INDENT3 = 3;
    static final int INDENT4 = 4;
    static final int INDENT5 = 5;
    static final int TITLE = 15;
    static final int BLANK = 32;
    int previousStatus;
    int status;
    int count;
    String codeTitle;
    int no;
    boolean fermeture = false;

    public Outline(String string, String string2) {
        this.name = string2;
        this.path = Path.merge(string, string2);
    }

    public void setFile(String string, String string2) {
        this.htmlFile = Path.merge(string, string2);
        this.htmlDir = string;
        this.htmlName = string2;
    }

    public int load() {
        int n = 0;
        this.lines = new VectorString(1024, 128);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.path));
            do {
                if ((string = bufferedReader.readLine()) == null) continue;
                this.lines.addElement(string);
                ++n;
            } while (string != null);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Enable to read ".concat(String.valueOf(String.valueOf(this.path))));
        }
        return n;
    }

    private void put(String string) {
        try {
            this.bw.write(string, 0, string.length());
            this.bw.newLine();
        }
        catch (IOException iOException) {
            System.out.println("Enable to write ".concat(String.valueOf(String.valueOf(string))));
        }
    }

    void indent(String string, int n, int n2, String string2) {
        String string3 = "";
        this.codeTitle = "h".concat(String.valueOf(String.valueOf(Integer.toString(n2))));
        for (int i = 0; i < n; ++i) {
            string3 = String.valueOf(String.valueOf(string3)).concat("&nbsp;");
        }
        String string4 = "title".concat(String.valueOf(String.valueOf(this.no++)));
        String string5 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string3))).append("<a href=").append(g).append("#").append(string4).append(g).append(">").append("<span style=\"font size=").append(string2).append(";color=green\">").append(string).append("</span>").append("</a>")));
        this.summary.addElement(string5);
        if (this.fermeture) {
            this.body.addElement("</pre>");
        }
        this.body.addElement(String.valueOf(String.valueOf(new StringBuffer("<").append(this.codeTitle).append("><a name=").append(g).append(string4).append(g).append("></a>"))));
        this.body.addElement(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append("</").append(this.codeTitle).append("> <pre>"))));
        this.fermeture = true;
    }

    private void addLine(String string) {
        if (string == null) {
            return;
        }
        this.previousStatus = this.status;
        switch (this.status) {
            case 15: {
                this.title.addElement(String.valueOf(String.valueOf(new StringBuffer("<center>").append(string).append("</center>"))));
                break;
            }
            case 0: {
                this.indent(string, 0, 3, "14pt");
                break;
            }
            case 1: {
                this.indent(string, 1, 3, "12pt");
                break;
            }
            case 2: {
                this.indent(string, 2, 4, "11pt");
                break;
            }
            case 3: {
                this.indent(string, 3, 5, "10pt");
                break;
            }
            case 4: {
                this.indent(string, 4, 6, "9pt");
                break;
            }
            case 5: {
                this.indent(string, 5, 6, "9pt");
                break;
            }
            case 32: {
                this.body.addElement(string);
                break;
            }
            default: {
                this.previousStatus = 16;
                this.body.addElement(string);
            }
        }
    }

    private boolean isBlank(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isSpaceChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isBlank(int n) {
        return this.isBlank(this.lines.elementAt(n));
    }

    private void parseLine(int n) {
        int n2;
        String string = this.lines.elementAt(n);
        if (this.summary.size() == 0 && string.length() > 6 && string.substring(0, 6).equals("      ")) {
            this.status = 15;
            this.addLine(string);
            return;
        }
        if (this.isBlank(string)) {
            this.status = 32;
            this.addLine(string);
            return;
        }
        if (this.previousStatus != 32) {
            this.status = 16;
            this.addLine(string);
            return;
        }
        if (n >= this.lines.size() || n < this.lines.size() - 1 && !this.isBlank(n + 1)) {
            this.status = 16;
            this.addLine(string);
            return;
        }
        int n3 = Math.min(string.length(), 5);
        for (n2 = 0; n2 < n3 && Character.isSpaceChar(string.charAt(n2)); ++n2) {
        }
        this.status = n2;
        this.addLine(string);
    }

    private void putTitle(int n) {
        this.put(this.title.elementAt(n));
        ++this.count;
    }

    private void putSummary(int n) {
        this.put(String.valueOf(String.valueOf(this.summary.elementAt(n))).concat("<br>"));
        ++this.count;
    }

    private void putBody(int n) {
        this.put(this.body.elementAt(n));
        ++this.count;
    }

    public int createHtml() {
        int n;
        if (this.load() == 0) {
            return 0;
        }
        this.title = new VectorString();
        this.summary = new VectorString(this.count / 10, 32);
        this.body = new VectorString(this.count * 9 / 10, 32);
        try {
            this.fw = new FileWriter(this.htmlFile);
            this.bw = new BufferedWriter(this.fw);
        }
        catch (IOException iOException) {
            System.out.println("Enable to make ".concat(String.valueOf(String.valueOf(this.htmlFile))));
        }
        this.no = 0;
        for (n = 0; n < this.lines.size(); ++n) {
            this.parseLine(n);
        }
        this.put("<HTML>");
        this.put("<HEAD>");
        this.put("<TITLE> Manual </TITLE>");
        this.put(String.valueOf(String.valueOf(new StringBuffer("<STYLE TYPE=").append(g).append("text/css").append(g).append(" MEDIA=screen >"))));
        this.put("<!--");
        this.put(String.valueOf(String.valueOf(new StringBuffer(" BODY { font-family: ").append(g).append("Courrier New").append(g).append(", Courrier, mono, Monospaced, Arial }"))));
        this.put(String.valueOf(String.valueOf(new StringBuffer(" TABLE { font-family: ").append(g).append("Courrier New").append(g).append(", Courrier, mono, Monospaced, Arial  }"))));
        this.put(" H3 { font-size: 12pt; color: green }");
        this.put(" H4 { font-size: 11pt; color: green }");
        this.put(" H5 { font-size: 10pt; color: green }");
        this.put(" H6 { font-size: 9pt; color: green }");
        this.put(" H7 { font-size: 9pt; color: green }");
        this.put(String.valueOf(String.valueOf(new StringBuffer(" PRE { font-family: ").append(g).append("Courrier New").append(g).append(", Courrier, mono, Monospaced, Arial  }"))));
        this.put(" A:link { text-decoration: none }");
        this.put(" A:visited { text-decoration: none }");
        this.put(" A:hover { text-decoration: none }");
        this.put("-->");
        this.put("</STYLE>");
        this.put("</HEAD>");
        if (Preferences.pageColor.equalsIgnoreCase("None")) {
            this.put("<BODY>");
        } else {
            this.put(String.valueOf(String.valueOf(new StringBuffer("<BODY bgcolor=").append(Preferences.pageColor).append(">"))));
        }
        for (n = 0; n < this.title.size(); ++n) {
            this.putTitle(n);
        }
        this.put("<br><hr>");
        this.put(String.valueOf(String.valueOf(new StringBuffer("<TABLE align=").append(g).append("center").append(g).append(" width=").append(g).append("500").append(g).append(">"))));
        this.put("<TR><TD>");
        for (n = 0; n < this.summary.size(); ++n) {
            this.putSummary(n);
        }
        this.put("</TD></TR>");
        this.put("</TABLE>");
        this.put("<HR><br>");
        for (n = 0; n < this.body.size(); ++n) {
            this.putBody(n);
        }
        if (this.fermeture) {
            this.put("</PRE>");
        }
        this.put("</BODY>");
        this.put("</HTML>");
        try {
            this.bw.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.count;
    }
}

