/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Archiver;
import common.DBPanel;
import common.DCheckbox;
import common.DialogCYN;
import common.DialogMessage;
import common.DirManager;
import common.Directory;
import common.PanelGenerator;
import common.Path;
import common.Preferences;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.io.File;

public class PanelArchive
extends PanelGenerator {
    DCheckbox checkRecurse;
    DCheckbox checkInclude;

    public PanelArchive(Frame frame) {
        super(frame);
        this.setTitle("ARCHIVER");
        this.setAction("Make an archive of selected items");
        DBPanel dBPanel = new DBPanel(1);
        dBPanel.setLabel("Options");
        this.add((Component)dBPanel, "Center");
        this.checkRecurse = new DCheckbox("Recurse sub-directories", Preferences.ArcRecurse);
        this.checkRecurse.setBounds(32, 32, 200, 24);
        this.checkRecurse.addItemListener(this);
        dBPanel.add(this.checkRecurse);
        this.checkInclude = new DCheckbox("Include full paths", Preferences.ArcInclude);
        this.checkInclude.setBounds(32, 64, 200, 24);
        this.checkInclude.addItemListener(this);
        dBPanel.add(this.checkInclude);
        this.htmlName = "";
    }

    public void init(DirManager dirManager, DirManager dirManager2, boolean bl) {
        super.init(dirManager, dirManager2, bl);
        switch (this.Mode) {
            case 1: {
                this.setAction("Archive the selected file");
                break;
            }
            case 3: {
                this.setAction("Archive content of the selected folder");
                break;
            }
            case 2: {
                this.setAction("Archive the tagged list");
                break;
            }
        }
    }

    public boolean archive(DirManager dirManager) {
        String string = this.getDir();
        String string2 = this.getFilename();
        String string3 = this.getSource();
        Archiver.setMessage("Error");
        if (this.Mode == 0) {
            this.dispTip("Nothing to do! Select files/dir in first panel, please...");
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            this.dispTip("Give a name to the archive, please!");
            return false;
        }
        if (Path.hasExtension(string2)) {
            if (Directory.isGZip(string2) && this.Mode != 1) {
                this.dispTip("GZip require a single file");
                return false;
            }
            if (!Directory.isArchive(string2)) {
                this.dispTip("Give a valid archive extension or none (default is zip)");
                return false;
            }
        } else {
            string2 = String.valueOf(String.valueOf(string2)).concat(".zip");
        }
        this.setFilename(string2);
        String string4 = Path.merge(string, string2);
        boolean bl = new File(string, string2).exists();
        if (bl) {
            DialogCYN dialogCYN = new DialogCYN(this.frame, String.valueOf(String.valueOf(new StringBuffer("Erasing the current ").append(string2.toUpperCase()).append(" archive, continue?"))));
            dialogCYN.setVisible(true);
            if (dialogCYN.answer != 1) {
                return false;
            }
        }
        boolean bl2 = false;
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        if (this.Mode == 1) {
            this.message(String.valueOf(String.valueOf(new StringBuffer("Archiving ").append(string3).append(" into ").append(string4))));
            bl2 = Archiver.archiveAnyFile(string3, string4);
            if (bl2) {
                this.message("Archive completed");
            } else {
                this.message(Archiver.getMessage());
            }
            this.setCursor(cursor);
            return true;
        }
        String[] stringArray = dirManager.getSelectedItems();
        String string5 = null;
        String string6 = dirManager.getDir();
        if (this.Mode == 3) {
            String string7 = stringArray[0];
            this.message(String.valueOf(String.valueOf(new StringBuffer("Archiving ").append(string7).append("'s content into ").append(string4))));
            if (Preferences.ArcInclude) {
                string5 = string6;
            } else {
                string5 = Path.merge(string6, string7);
                stringArray = new File(string6, string7).list();
            }
        }
        if (this.Mode == 2) {
            this.message(String.valueOf(String.valueOf(new StringBuffer("Archiving ").append(string3).append(" into ").append(string4))));
            string5 = string6;
        }
        if (stringArray.length > 0) {
            int n = Archiver.archive(string5, stringArray, string4);
            this.message(String.valueOf(String.valueOf(new StringBuffer("Archived ").append(n).append(" files"))));
            if (Archiver.error) {
                new DialogMessage(this.frame, "Error in archiving").setVisible(true);
            }
        } else {
            this.dispTip("Nothing to do");
        }
        this.setCursor(cursor);
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.checkRecurse) {
            Preferences.ArcRecurse = this.checkRecurse.getState();
        } else if (object == this.checkInclude) {
            Preferences.ArcInclude = this.checkInclude.getState();
        }
    }
}

