/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.util.NoSuchElementException;

public class VectorInt {
    public int[] elementData;
    public int elementCount;
    protected int capacityIncrement;
    public int index = 0;

    public VectorInt(int n, int n2) {
        this.elementData = new int[n];
        this.capacityIncrement = n2;
    }

    public VectorInt(int n) {
        this(n, 1);
    }

    public VectorInt() {
        this(16);
    }

    public final synchronized void copyInto(int[] nArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            nArray[n] = this.elementData[n];
        }
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            int[] nArray = this.elementData;
            this.elementData = new int[this.elementCount];
            VectorInt.copy(nArray, this.elementData, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            int[] nArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new int[n3];
            VectorInt.copy(nArray, this.elementData, this.elementCount);
        }
    }

    public final synchronized void setSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = 0;
            }
        }
        this.elementCount = n;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(int n) {
        return this.indexOf(n, 0) >= 0;
    }

    public final int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public final synchronized int indexOf(int n, int n2) {
        for (int i = n2; i < this.elementCount; ++i) {
            if (n != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(int n, int n2) {
        for (int i = n2; i >= 0; --i) {
            if (n != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final synchronized int elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n))).append(" >= ").append(this.elementCount))));
        }
        return this.elementData[n];
    }

    public final synchronized int firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized int lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(int n, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" >= ").append(this.elementCount))));
        }
        this.elementData[n2] = n;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n))).append(" >= ").append(this.elementCount))));
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            VectorInt.copy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = 0;
    }

    public final synchronized void insertElementAt(int n, int n2) {
        if (n2 >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n2))).append(" > ").append(this.elementCount))));
        }
        this.ensureCapacity(this.elementCount + 1);
        VectorInt.copy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        this.elementData[n2] = n;
        ++this.elementCount;
    }

    public final synchronized void addElement(int n) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = n;
    }

    public final synchronized boolean removeElement(int n) {
        int n2 = this.indexOf(n);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = 0;
        }
        this.elementCount = 0;
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(new Integer(this.elementData[i]).toString());
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void copy(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
        }
    }

    public static void copy(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            nArray2[i + n2] = nArray[i + n];
        }
    }

    public void restart() {
        this.index = 0;
    }

    public boolean hasMoreElements() {
        return this.index < this.elementCount;
    }

    public int nextElement() {
        if (this.index < this.elementCount) {
            return this.elementData[this.index++];
        }
        throw new NoSuchElementException("IntEnumerator");
    }
}

