/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;

public class UtilComponent {
    public static int getFontHeight(Graphics graphics) {
        return UtilComponent.getFontHeight(graphics.getFontMetrics());
    }

    public static int getFontHeight(Font font) {
        return UtilComponent.getFontHeight(Toolkit.getDefaultToolkit().getFontMetrics(font));
    }

    public static int getFontHeight(FontMetrics fontMetrics) {
        return fontMetrics.getHeight();
    }

    public static int getStringWidth(Graphics graphics, String string) {
        return UtilComponent.getStringWidth(graphics.getFontMetrics(), string);
    }

    public static int getStringWidth(Font font, String string) {
        return UtilComponent.getStringWidth(Toolkit.getDefaultToolkit().getFontMetrics(font), string);
    }

    public static int getStringWidth(FontMetrics fontMetrics, String string) {
        return fontMetrics.stringWidth(string);
    }

    public static Font getDefaultFont() {
        return new Font("Dialog", 12, 0);
    }

    public static Graphics getGraphics(Image image, Component component) {
        if (image == null) {
            return null;
        }
        Graphics graphics = image.getGraphics();
        if (graphics != null && component != null && component.getFont() != null) {
            graphics.setFont(component.getFont());
        }
        return graphics;
    }

    public static int findComponent(Container container, Component component) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] != component) continue;
            return i;
        }
        return -1;
    }
}

