/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

public class DBar
extends Container {
    public static final int NONE = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int LINE = 3;
    public static final int SEPARED = 4;
    protected int style;
    protected Color dark;
    protected Color light;
    protected int width;
    protected int height;
    protected Insets insets = new Insets(1, 1, 1, 1);

    public DBar() {
        this(3);
    }

    public DBar(int n) {
        this.style = n;
    }

    public void setBevelStyle(int n) {
        this.style = n;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void addSeparator(int n, int n2) {
        this.add(new DSeparator(n, n2));
    }

    public void addSpacer(int n, int n2) {
        this.add(new DBarSpacer(n, n2));
    }

    public void setHeight(int n) {
        this.addSpacer(0, n);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.width = dimension.width;
        this.height = dimension.height;
        Color color = this.getBackground();
        this.light = color.brighter();
        this.dark = color.darker();
        graphics.setColor(color);
        int n = this.insets.left;
        int n2 = this.insets.top;
        graphics.fillRect(n, n2, this.width - n - this.insets.right, this.height - n2 - this.insets.bottom);
        this.drawBorder(graphics, 0, 0, this.width - 1, this.height - 1);
        super.paint(graphics);
    }

    protected void drawBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.style) {
            case 1: {
                graphics.setColor(this.light);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics.setColor(this.dark);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
                break;
            }
            case 2: {
                graphics.setColor(this.dark);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics.setColor(this.light);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
                break;
            }
            case 3: {
                graphics.setColor(this.getForeground());
                graphics.drawRect(n, n2, n3, n4);
                break;
            }
            case 4: {
                graphics.setColor(this.dark);
                graphics.drawLine(n, n2, n + n3, n2);
                break;
            }
            case 0: {
                break;
            }
        }
    }
}

