/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.io.Serializable;

public class DTreeNode
implements Serializable {
    DTreeNode sibling;
    DTreeNode child;
    DTreeNode parent;
    String text;
    transient Image collapsedImage;
    transient Image expandedImage;
    int numberOfChildren;
    Object dataObject;
    DTreeView treeView;
    int depth = -1;
    boolean isExpanded = false;
    boolean isDirectory = false;
    boolean isExpandable = false;

    public DTreeNode() {
    }

    public DTreeNode(String string, DTreeView dTreeView) {
        this(string, null, null, dTreeView);
    }

    public DTreeNode(String string, Image image, Image image2, DTreeView dTreeView) {
        this.text = string;
        this.sibling = null;
        this.child = null;
        this.collapsedImage = image;
        this.expandedImage = image2;
        this.numberOfChildren = 0;
        this.dataObject = null;
        this.treeView = dTreeView;
    }

    public void setText(String string) {
        this.text = new String(string);
        if (this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public void setDataObject(Object object) {
        this.dataObject = object;
    }

    void setDepth(int n) {
        this.depth = n;
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public String getText() {
        return this.text;
    }

    public DTreeNode getParent() {
        return this.parent;
    }

    public DTreeNode getChild() {
        return this.child;
    }

    public DTreeNode getSibling() {
        return this.sibling;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public boolean isExpandable() {
        return this.child != null || this.isExpandable;
    }

    public boolean isIncomplete() {
        return this.child == null && this.isDirectory;
    }

    public void expand() {
        if (this.isExpandable()) {
            this.isExpanded = true;
            if (this.treeView != null) {
                this.treeView.triggerRedraw();
            }
        }
    }

    public void collapse() {
        this.isExpanded = false;
        if (this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public void toggle() {
        if (this.isExpanded) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public Image getImage() {
        return this.isExpanded && this.expandedImage != null ? this.expandedImage : this.collapsedImage;
    }

    public void setExpandedImage(Image image) {
        this.expandedImage = image;
        if (this.isExpanded() && this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public void setCollapsedImage(Image image) {
        this.collapsedImage = image;
        if (!this.isExpanded() && this.treeView != null) {
            this.treeView.triggerRedraw();
        }
    }

    public String toString() {
        return "Node ".concat(String.valueOf(this.text));
    }
}

