/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.apache.log4j.Category;
import org.nakedobjects.basicgui.event.dnd.DragDropEvent;
import org.nakedobjects.basicgui.event.dnd.DragSource;
import org.nakedobjects.basicgui.event.dnd.DropDestination;
import org.nakedobjects.basicgui.event.dnd.DroppableContainers;
import org.nakedobjects.basicgui.event.popup.MenuOption;
import org.nakedobjects.basicgui.event.popup.MenuOptionSet;
import org.nakedobjects.basicgui.event.popup.MenuOptionTarget;
import org.nakedobjects.basicgui.view.Display;
import org.nakedobjects.basicgui.view.DisplayMechanism;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.UsesViewer;
import org.nakedobjects.basicgui.view.ViewColor;

public class DisplayFrame
extends Frame
implements Display,
UsesViewer,
DragSource,
DropDestination,
MenuOptionTarget {
    private static int nextNo = 1;
    private static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$basicgui$view$DisplayFrame == null ? (class$org$nakedobjects$basicgui$view$DisplayFrame = DisplayFrame.class$("org.nakedobjects.basicgui.view.DisplayFrame")) : class$org$nakedobjects$basicgui$view$DisplayFrame));
    private final int no = nextNo++;
    private int borderWidth = 0;
    private DisplayMechanism delegate;
    private Image doubleBuffer;
    private Graphics bufferGraphics;
    static /* synthetic */ Class class$org$nakedobjects$basicgui$view$DisplayFrame;

    public DisplayFrame() {
        this(false);
    }

    public DisplayFrame(ObjectViewer objectViewer) {
        this(objectViewer, objectViewer.isResizable());
    }

    public DisplayFrame(ObjectViewer objectViewer, boolean bl) {
        this(bl);
        objectViewer.setDisplay(this);
        this.useViewer(objectViewer);
        this.delegate = new DisplayMechanism(this, objectViewer);
        this.setTitle(objectViewer.getObject().getNakedClass().getSingularName() + " instance");
    }

    private DisplayFrame(boolean bl) {
        this.enableEvents(48L);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DisplayFrame.this.close();
            }
        });
        this.setResizable(bl);
        DroppableContainers.addDroppable(this);
        this.delegate = new DisplayMechanism(this);
    }

    public void cancel(DragDropEvent dragDropEvent) {
        this.delegate.cancel(dragDropEvent);
    }

    private void close() {
        ((Component)this).setVisible(false);
        DroppableContainers.removeDroppable(this);
        this.delegate.dispose();
        this.dispose();
    }

    public void copy(DragDropEvent dragDropEvent) {
        this.delegate.copy(dragDropEvent);
    }

    public String debugDetails() {
        return this.delegate.debugDetails();
    }

    public void drag(DragDropEvent dragDropEvent) {
        this.delegate.drag(dragDropEvent);
    }

    public void dragEnter(DragDropEvent dragDropEvent) {
        this.delegate.dragEnter(dragDropEvent);
    }

    public void dragExit(DragDropEvent dragDropEvent) {
        this.delegate.dragExit(dragDropEvent);
    }

    public void dragging(DragDropEvent dragDropEvent) {
        this.delegate.dragging(dragDropEvent);
    }

    public void drop(DragDropEvent dragDropEvent) {
        this.delegate.drop(dragDropEvent);
    }

    public Component getComponent() {
        return this;
    }

    public Insets getInsets() {
        return this.delegate.getInsets(super.getInsets());
    }

    public Dimension getMinimumSize() {
        if (this.getComponentCount() > 0) {
            Dimension dimension = super.getMinimumSize();
            Dimension dimension2 = this.delegate.getBorderSize();
            Insets insets = super.getInsets();
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
            return dimension;
        }
        return this.delegate.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public ObjectViewer getViewer() {
        return this.delegate.getViewer();
    }

    public String idString() {
        return "DisplayFrame" + this.no;
    }

    public void menuOptions(MenuOptionSet menuOptionSet) {
        MenuOption menuOption = new MenuOption("Close", 0){

            public void action(MenuOptionTarget menuOptionTarget, Point point) {
                DisplayFrame.this.close();
            }
        };
        menuOptionSet.add(menuOption);
        this.delegate.menuOptions(menuOptionSet);
    }

    public void move(DragDropEvent dragDropEvent) {
        this.delegate.move(dragDropEvent);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void paintContent() {
        this.delegate.paintContent(this.getGraphics(), super.getInsets());
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        this.delegate.processMouseEvent(mouseEvent);
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.delegate.processMouseMotionEvent(mouseEvent);
        super.processMouseMotionEvent(mouseEvent);
    }

    public void refresh() {
        this.invalidate();
        this.pack();
        this.repaint();
    }

    public void setBorder(int n) {
        this.borderWidth = n;
    }

    public void showPopup(Point point, boolean bl) {
        this.delegate.showPopup(this, point, bl);
    }

    public String targetName() {
        return this.idString();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void update(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this.doubleBuffer == null || this.doubleBuffer.getWidth(null) != n || this.doubleBuffer.getHeight(null) != n2) {
            this.doubleBuffer = this.createImage(n, n2);
            this.bufferGraphics = this.doubleBuffer.getGraphics();
        }
        this.bufferGraphics.setColor(ViewColor.windowBackground);
        this.bufferGraphics.fillRect(0, 0, n, n2);
        this.delegate.paint(this.bufferGraphics, super.getInsets());
        super.paint(this.bufferGraphics);
        graphics.drawImage(this.doubleBuffer, 0, 0, this);
    }

    public void useViewer(ObjectViewer objectViewer) {
        this.setResizable(objectViewer.isResizable());
        this.delegate.useViewer(objectViewer);
    }

    public void vacantDrop(DragDropEvent dragDropEvent) {
        this.delegate.vacantDrop(dragDropEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

