/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import org.nakedobjects.basicgui.view.PrimitiveValue;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedValue;
import org.nakedobjects.object.reflect.Value;

public class FieldValue
implements PrimitiveValue {
    private Value field;
    private NakedObject parentObject;
    private NakedValue value;
    private boolean isEditable;

    public FieldValue(NakedObject nakedObject, Value value) {
        this.parentObject = nakedObject;
        this.field = value;
        if (value == null) {
            throw new IllegalArgumentException("EditField can only be used for values");
        }
        this.update();
    }

    public boolean canEdit() {
        return this.isEditable | this.parentObject.isFinder();
    }

    public Value getAttribute() {
        return this.field;
    }

    public NakedValue getNakedDatum() {
        return this.value;
    }

    public NakedObject getParentObject() {
        return this.parentObject;
    }

    public String getText() {
        if (this.value == null) {
            return "";
        }
        return this.value.title().toString();
    }

    public boolean isValid() {
        return this.value.isValid();
    }

    public void setAs(String string) {
        this.field.set(this.parentObject, string);
    }

    public void update() {
        this.value = (NakedValue)this.field.get(this.parentObject);
        if (this.value == null) {
            this.isEditable = false;
        } else {
            boolean bl = this.field.isDerived();
            boolean bl2 = this.field.getAbout(this.parentObject).canUse().isAllowed();
            boolean bl3 = this.value.about().canUse().isAllowed();
            boolean bl4 = this.parentObject.about().canUse().isAllowed();
            this.isEditable = !bl && bl3 && bl4 && bl2;
        }
    }
}

