/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.value;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.ValueParseException;
import org.nakedobjects.object.value.Magnitude;

public class Time
extends Magnitude
implements Externalizable {
    private static final DateFormat SHORT_FORMAT = DateFormat.getTimeInstance(3);
    private static final DateFormat MEDIUM_FORMAT = DateFormat.getTimeInstance(2);
    private static final DateFormat LONG_FORMAT = DateFormat.getTimeInstance(1);
    static final long zero;
    private transient DateFormat format = SHORT_FORMAT;
    private Date date;

    public Time() {
        this.setValue(new Date());
    }

    public Time(int n, int n2) {
        this.setValue(n, n2);
    }

    public Time(Time time) {
        this.date = time.date;
    }

    static long getZero() {
        return zero;
    }

    public void add(int n, int n2) {
        this.checkCanOperate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        calendar.add(12, n2);
        calendar.add(11, n);
        this.set(calendar);
    }

    private void checkTime(int n, int n2, int n3) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("Hour must be in the range 0 - 23 inclusive");
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("Minute must be in the range 0 - 59 inclusive");
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException("Second must be in the range 0 - 59 inclusive");
        }
    }

    public void clear() {
        this.date = null;
    }

    public void copyObject(Naked naked) {
        if (!(naked instanceof Time)) {
            throw new IllegalArgumentException("Can only copy the value of  a Date object");
        }
        this.date = naked == null ? null : ((Time)naked).date;
    }

    private Calendar createCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(5, 1);
        calendar.set(2, 0);
        calendar.set(1, 1970);
        return calendar;
    }

    public Date dateValue() {
        return this.date == null ? null : this.date;
    }

    public Date getDate() {
        this.checkCanOperate();
        return this.date;
    }

    public boolean isEmpty() {
        return this.date == null;
    }

    public boolean isEqualTo(Magnitude magnitude) {
        if (magnitude instanceof Time) {
            return this.date == null ? false : this.date.equals(((Time)magnitude).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    public boolean isLessThan(Magnitude magnitude) {
        this.checkCanOperate();
        if (magnitude instanceof Time) {
            return this.date != null && !magnitude.isEmpty() && this.date.before(((Time)magnitude).date);
        }
        throw new IllegalArgumentException("Parameter must be of type Time");
    }

    public long longValue() {
        this.checkCanOperate();
        return this.date.getTime() / 1000L;
    }

    public void parse(String string) throws ValueParseException {
        if (string.trim().equals("")) {
            this.clear();
        } else {
            string = string.trim();
            String string2 = string.toLowerCase();
            Calendar calendar = this.createCalendar();
            if (!string2.equals("now")) {
                if (string2.startsWith("+")) {
                    int n = Integer.valueOf(string2.substring(1));
                    calendar.setTime(this.date);
                    calendar.add(11, n);
                } else if (string2.startsWith("-")) {
                    int n = Integer.valueOf(string2.substring(1));
                    calendar.setTime(this.date);
                    calendar.add(11, -n);
                } else {
                    DateFormat[] dateFormatArray = new DateFormat[]{LONG_FORMAT, MEDIUM_FORMAT, SHORT_FORMAT};
                    int n = 0;
                    while (n < dateFormatArray.length) {
                        try {
                            calendar.setTime(dateFormatArray[n].parse(string));
                            break;
                        }
                        catch (ParseException parseException) {
                            if (n + 1 == dateFormatArray.length) {
                                throw new ValueParseException(parseException, "Invalid time " + string);
                            }
                            ++n;
                        }
                    }
                }
            }
            this.set(calendar);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput.readBoolean()) {
            this.date.setTime(objectInput.readLong());
        }
    }

    public void reset() {
        this.setValue(new Date());
    }

    private void set(Calendar calendar) {
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(5, 1);
        calendar.set(2, 0);
        calendar.set(1, 1970);
        this.date = calendar.getTime();
    }

    public void setValue(int n, int n2) {
        this.checkTime(n, n2, 0);
        Calendar calendar = this.createCalendar();
        calendar.set(11, n);
        calendar.set(12, n2);
        this.set(calendar);
    }

    public void setValue(Time time) {
        this.date = time == null ? null : new Date(time.date.getTime());
    }

    public void setValue(Date date) {
        if (date == null) {
            this.date = null;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.set(calendar);
        }
    }

    public Title title() {
        return new Title(this.date == null ? "" : this.format.format(this.date));
    }

    public Calendar calendarValue() {
        if (this.date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        return calendar;
    }

    public void restoreString(String string) {
        if (string.equals("NULL")) {
            this.clear();
        } else {
            int n = Integer.valueOf(string.substring(0, 2));
            int n2 = Integer.valueOf(string.substring(2));
            this.setValue(n, n2);
        }
    }

    public String saveString() {
        Calendar calendar = this.calendarValue();
        if (calendar == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer(4);
        int n = calendar.get(11);
        stringBuffer.append(n <= 9 ? "0" : "");
        stringBuffer.append(n);
        int n2 = calendar.get(12);
        stringBuffer.append(n2 <= 9 ? "0" : "");
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.date == null);
        objectOutput.writeLong(this.date.getTime());
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(5, 1);
        calendar.set(2, 0);
        calendar.set(1, 1970);
        zero = calendar.getTime().getTime();
    }
}

