/*
 * Decompiled with CFR 0.152.
 */
package tools;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import dialog.DFiler;
import dialog.DJpeg;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import painter.GIFEncoder;
import tools.ImageWindow;
import watcher.ImageWindowCloser;

public class Filer {
    JFont JF;
    JDesktopPane lp;
    int Width;
    int Height;

    public Filer() {
        this.JF = this.JF;
        this.lp = JFont.lp;
    }

    public void GIFSave(JPanel jPanel, String string) {
        try {
            Color color = jPanel.getBackground();
            color.getTransparency();
            jPanel.setOpaque(false);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            BufferedImage bufferedImage = (BufferedImage)jPanel.createImage(this.Width, this.Height);
            Graphics graphics = bufferedImage.getGraphics();
            jPanel.paint(graphics);
            BufferedImage bufferedImage2 = bufferedImage;
            GIFEncoder gIFEncoder = new GIFEncoder(bufferedImage2);
            gIFEncoder.Write(bufferedOutputStream);
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Caught : " + exception);
        }
    }

    public void JPEGSave(Component component, String string) {
        DJpeg dJpeg = new DJpeg();
        int n = dJpeg.getQuality();
        float f = (float)n / 100.0f;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            BufferedImage bufferedImage = (BufferedImage)component.createImage(this.Width, this.Height);
            Graphics graphics = bufferedImage.getGraphics();
            component.paint(graphics);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
            JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
            jPEGEncodeParam.setQuality(f, true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Caught : " + exception);
        }
    }

    public void Load() {
        int n = this.lp.getWidth();
        JInternalFrame jInternalFrame = new JInternalFrame();
        Image image = Toolkit.getDefaultToolkit().getImage("images/ic_JFont_Reference.gif");
        jInternalFrame.setFrameIcon(new ImageIcon(image));
        jInternalFrame.setClosable(true);
        jInternalFrame.setMaximizable(true);
        jInternalFrame.setIconifiable(true);
        jInternalFrame.setResizable(true);
        ImageWindowCloser imageWindowCloser = new ImageWindowCloser();
        jInternalFrame.addInternalFrameListener(imageWindowCloser);
        String string = this.getFileName("LOAD");
        if (string == null) {
            return;
        }
        ImageWindow imageWindow = new ImageWindow(string);
        jInternalFrame.setBounds(20 * (JFont.refeCount % 10) + n / 2, 20 * (JFont.refeCount % 10), ImageWindow.Width + 6, ImageWindow.Height + 23);
        ++JFont.refeCount;
        int n2 = 0;
        jInternalFrame.setContentPane(imageWindow);
        jInternalFrame.setTitle(ImageWindow.file);
        this.lp.add((Component)jInternalFrame, new Integer(n2));
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public void Save() {
        JPanel jPanel = this.getCanvas();
        String string = this.getFileName("SAVE");
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (string.toUpperCase().endsWith(".GIF")) {
            this.GIFSave(jPanel, string);
        } else if (string.toUpperCase().endsWith(".JPG")) {
            this.JPEGSave(jPanel, string);
        } else if (string.toUpperCase().endsWith(".JPEG")) {
            this.JPEGSave(jPanel, string);
        }
    }

    private JPanel getCanvas() {
        if (JFont.editCount == 0 && JFont.refeCount == 0) {
            return null;
        }
        JInternalFrame[] jInternalFrameArray = this.lp.getAllFrames();
        JPanel jPanel = (JPanel)jInternalFrameArray[0].getContentPane();
        this.Width = jPanel.getWidth();
        this.Height = jPanel.getHeight();
        return jPanel;
    }

    public String getFileName(String string) {
        FileDialog fileDialog = null;
        if (string.equals("LOAD")) {
            fileDialog = new FileDialog((Frame)JFont.frame, "Load file", 0);
        } else if (string.equals("SAVE")) {
            fileDialog = new FileDialog((Frame)JFont.frame, "Save file", 1);
        } else {
            return null;
        }
        fileDialog.setDirectory(System.getProperty("user.dir"));
        if (string.equals("LOAD")) {
            fileDialog.setFile("*.GIF;*.JPG;*.JPEG");
        }
        ((Component)fileDialog).setVisible(true);
        String string2 = null;
        string2 = fileDialog.getFile();
        if (string2 == null) {
            return string2;
        }
        if (string.equals("LOAD") && !this.isImageFile(string2)) {
            new DFiler().InvalidFileName();
            this.getFileName("LOAD");
        }
        string2 = String.valueOf(fileDialog.getDirectory().replace('\\', '/')) + string2;
        System.setProperty("user.dir", fileDialog.getDirectory());
        return string2;
    }

    private boolean isCorrect(String string) {
        File file;
        return this.isImageFile(string) && (file = new File(string)).exists();
    }

    boolean isImageFile(String string) {
        if (string.endsWith(".gif")) {
            return true;
        }
        if (string.endsWith(".GIF")) {
            return true;
        }
        if (string.endsWith(".jpg")) {
            return true;
        }
        if (string.endsWith(".JPG")) {
            return true;
        }
        if (string.endsWith(".jpeg")) {
            return true;
        }
        return string.endsWith(".JPEG");
    }
}

