/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.util.Arrays;

public class BarcodeEAN
extends Barcode {
    static int[] GUARD_EMPTY = new int[0];
    static int[] GUARD_UPCA = new int[]{0, 2, 4, 6, 28, 30, 52, 54, 56, 58};
    static int[] GUARD_EAN13 = new int[]{0, 2, 28, 30, 56, 58};
    static int[] GUARD_EAN8 = new int[]{0, 2, 20, 22, 40, 42};
    static int[] GUARD_UPCE = new int[]{0, 2, 28, 30, 32};
    static float[] TEXTPOS_EAN13 = new float[]{6.5f, 13.5f, 20.5f, 27.5f, 34.5f, 41.5f, 53.5f, 60.5f, 67.5f, 74.5f, 81.5f, 88.5f};
    static float[] TEXTPOS_EAN8 = new float[]{6.5f, 13.5f, 20.5f, 27.5f, 39.5f, 46.5f, 53.5f, 60.5f};
    static byte[][] BARS = new byte[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
    static final int TOTALBARS_EAN13 = 59;
    static final int TOTALBARS_EAN8 = 43;
    static final int TOTALBARS_UPCE = 33;
    static final int TOTALBARS_SUPP2 = 13;
    static final int TOTALBARS_SUPP5 = 31;
    static final int ODD = 0;
    static final int EVEN = 1;
    static byte[][] PARITY13 = new byte[][]{{0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 0, 1}, {0, 0, 1, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 0, 0, 1}, {0, 1, 1, 1, 0, 0}, {0, 1, 0, 1, 0, 1}, {0, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 0}};
    static byte[][] PARITY2 = new byte[][]{{0, 0}, {0, 1}, {1, 0}, {1, 1}};
    static byte[][] PARITY5 = new byte[][]{{1, 1, 0, 0, 0}, {1, 0, 1, 0, 0}, {1, 0, 0, 1, 0}, {1, 0, 0, 0, 1}, {0, 1, 1, 0, 0}, {0, 0, 1, 1, 0}, {0, 0, 0, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 1}, {0, 0, 1, 0, 1}};
    static byte[][] PARITYE = new byte[][]{{1, 1, 1, 0, 0, 0}, {1, 1, 0, 1, 0, 0}, {1, 1, 0, 0, 1, 0}, {1, 1, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0}, {1, 0, 0, 1, 1, 0}, {1, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 1, 0}, {1, 0, 1, 0, 0, 1}, {1, 0, 0, 1, 0, 1}};

    public BarcodeEAN() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.guardBars = true;
            this.codeType = 1;
            this.code = "";
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static int calculateEANParity(String string) {
        int n2 = 3;
        int n3 = 0;
        int n4 = string.length() - 1;
        while (n4 >= 0) {
            int n5 = string.charAt(n4) - 48;
            n3 += n2 * n5;
            n2 ^= 2;
            --n4;
        }
        return (10 - n3 % 10) % 10;
    }

    public static String convertUPCAtoUPCE(String string) {
        if (string.length() != 12 || !string.startsWith("0") && !string.startsWith("1")) {
            return null;
        }
        if (string.substring(3, 6).equals("000") || string.substring(3, 6).equals("100") || string.substring(3, 6).equals("200")) {
            if (string.substring(6, 8).equals("00")) {
                return string.substring(0, 1) + string.substring(1, 3) + string.substring(8, 11) + string.substring(3, 4) + string.substring(11);
            }
        } else if (string.substring(4, 6).equals("00")) {
            if (string.substring(6, 9).equals("000")) {
                return string.substring(0, 1) + string.substring(1, 4) + string.substring(9, 11) + "3" + string.substring(11);
            }
        } else if (string.substring(5, 6).equals("0")) {
            if (string.substring(6, 10).equals("0000")) {
                return string.substring(0, 1) + string.substring(1, 5) + string.substring(10, 11) + "4" + string.substring(11);
            }
        } else if (string.charAt(10) >= '5' && string.substring(6, 10).equals("0000")) {
            return string.substring(0, 1) + string.substring(1, 6) + string.substring(10, 11) + string.substring(11);
        }
        return null;
    }

    public static byte[] getBarsEAN13(String string) {
        int n2;
        int[] nArray = new int[string.length()];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = string.charAt(n3) - 48;
            ++n3;
        }
        byte[] byArray = new byte[59];
        int n4 = 0;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byte[] byArray2 = PARITY13[nArray[0]];
        int n5 = 0;
        while (n5 < byArray2.length) {
            n2 = nArray[n5 + 1];
            byte[] byArray3 = BARS[n2];
            if (byArray2[n5] == 0) {
                byArray[n4++] = byArray3[0];
                byArray[n4++] = byArray3[1];
                byArray[n4++] = byArray3[2];
                byArray[n4++] = byArray3[3];
            } else {
                byArray[n4++] = byArray3[3];
                byArray[n4++] = byArray3[2];
                byArray[n4++] = byArray3[1];
                byArray[n4++] = byArray3[0];
            }
            ++n5;
        }
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        n2 = 7;
        while (n2 < 13) {
            int n6 = nArray[n2];
            byte[] byArray4 = BARS[n6];
            byArray[n4++] = byArray4[0];
            byArray[n4++] = byArray4[1];
            byArray[n4++] = byArray4[2];
            byArray[n4++] = byArray4[3];
            ++n2;
        }
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        return byArray;
    }

    public static byte[] getBarsEAN8(String string) {
        int n2;
        int[] nArray = new int[string.length()];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = string.charAt(n3) - 48;
            ++n3;
        }
        byte[] byArray = new byte[43];
        int n4 = 0;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        int n5 = 0;
        while (n5 < 4) {
            n2 = nArray[n5];
            byte[] byArray2 = BARS[n2];
            byArray[n4++] = byArray2[0];
            byArray[n4++] = byArray2[1];
            byArray[n4++] = byArray2[2];
            byArray[n4++] = byArray2[3];
            ++n5;
        }
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        n2 = 4;
        while (n2 < 8) {
            int n6 = nArray[n2];
            byte[] byArray3 = BARS[n6];
            byArray[n4++] = byArray3[0];
            byArray[n4++] = byArray3[1];
            byArray[n4++] = byArray3[2];
            byArray[n4++] = byArray3[3];
            ++n2;
        }
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        byArray[n4++] = 1;
        return byArray;
    }

    public static byte[] getBarsUPCE(String string) {
        int[] nArray = new int[string.length()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = string.charAt(n2) - 48;
            ++n2;
        }
        byte[] byArray = new byte[33];
        boolean bl = nArray[0] != 0;
        int n3 = 0;
        byArray[n3++] = 1;
        byArray[n3++] = 1;
        byArray[n3++] = 1;
        byte[] byArray2 = PARITYE[nArray[nArray.length - 1]];
        int n4 = 1;
        while (n4 < nArray.length - 1) {
            int n5 = nArray[n4];
            byte[] byArray3 = BARS[n5];
            if (byArray2[n4 - 1] == (bl ? (byte)1 : 0)) {
                byArray[n3++] = byArray3[0];
                byArray[n3++] = byArray3[1];
                byArray[n3++] = byArray3[2];
                byArray[n3++] = byArray3[3];
            } else {
                byArray[n3++] = byArray3[3];
                byArray[n3++] = byArray3[2];
                byArray[n3++] = byArray3[1];
                byArray[n3++] = byArray3[0];
            }
            ++n4;
        }
        byArray[n3++] = 1;
        byArray[n3++] = 1;
        byArray[n3++] = 1;
        byArray[n3++] = 1;
        byArray[n3++] = 1;
        byArray[n3++] = 1;
        return byArray;
    }

    public static byte[] getBarsSupplemental2(String string) {
        int[] nArray = new int[2];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = string.charAt(n2) - 48;
            ++n2;
        }
        byte[] byArray = new byte[13];
        int n3 = 0;
        int n4 = (nArray[0] * 10 + nArray[1]) % 4;
        byArray[n3++] = 1;
        byArray[n3++] = 1;
        byArray[n3++] = 2;
        byte[] byArray2 = PARITY2[n4];
        int n5 = 0;
        while (n5 < byArray2.length) {
            if (n5 == 1) {
                byArray[n3++] = 1;
                byArray[n3++] = 1;
            }
            int n6 = nArray[n5];
            byte[] byArray3 = BARS[n6];
            if (byArray2[n5] == 0) {
                byArray[n3++] = byArray3[0];
                byArray[n3++] = byArray3[1];
                byArray[n3++] = byArray3[2];
                byArray[n3++] = byArray3[3];
            } else {
                byArray[n3++] = byArray3[3];
                byArray[n3++] = byArray3[2];
                byArray[n3++] = byArray3[1];
                byArray[n3++] = byArray3[0];
            }
            ++n5;
        }
        return byArray;
    }

    public static byte[] getBarsSupplemental5(String string) {
        int[] nArray = new int[5];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = string.charAt(n2) - 48;
            ++n2;
        }
        byte[] byArray = new byte[31];
        int n3 = 0;
        int n4 = ((nArray[0] + nArray[2] + nArray[4]) * 3 + (nArray[1] + nArray[3]) * 9) % 10;
        byArray[n3++] = 1;
        byArray[n3++] = 1;
        byArray[n3++] = 2;
        byte[] byArray2 = PARITY5[n4];
        int n5 = 0;
        while (n5 < byArray2.length) {
            if (n5 != 0) {
                byArray[n3++] = 1;
                byArray[n3++] = 1;
            }
            int n6 = nArray[n5];
            byte[] byArray3 = BARS[n6];
            if (byArray2[n5] == 0) {
                byArray[n3++] = byArray3[0];
                byArray[n3++] = byArray3[1];
                byArray[n3++] = byArray3[2];
                byArray[n3++] = byArray3[3];
            } else {
                byArray[n3++] = byArray3[3];
                byArray[n3++] = byArray3[2];
                byArray[n3++] = byArray3[1];
                byArray[n3++] = byArray3[0];
            }
            ++n5;
        }
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        float f2 = 0.0f;
        float f3 = this.barHeight;
        if (this.font != null) {
            f3 = this.baseline <= 0.0f ? (f3 += -this.baseline + this.size) : (f3 += this.baseline - this.font.getFontDescriptor(3, this.size));
        }
        switch (this.codeType) {
            case 1: {
                f2 = this.x * 95.0f;
                if (this.font == null) break;
                f2 += this.font.getWidthPoint(this.code.charAt(0), this.size);
                break;
            }
            case 2: {
                f2 = this.x * 67.0f;
                break;
            }
            case 3: {
                f2 = this.x * 95.0f;
                if (this.font == null) break;
                f2 += this.font.getWidthPoint(this.code.charAt(0), this.size) + this.font.getWidthPoint(this.code.charAt(11), this.size);
                break;
            }
            case 4: {
                f2 = this.x * 51.0f;
                if (this.font == null) break;
                f2 += this.font.getWidthPoint(this.code.charAt(0), this.size) + this.font.getWidthPoint(this.code.charAt(7), this.size);
                break;
            }
            case 5: {
                f2 = this.x * 20.0f;
                break;
            }
            case 6: {
                f2 = this.x * 47.0f;
                break;
            }
            default: {
                throw new RuntimeException("Invalid code type.");
            }
        }
        return new Rectangle(f2, f3);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        Rectangle rectangle = this.getBarcodeSize();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f4 = this.barHeight - this.baseline;
            } else {
                f4 = -this.font.getFontDescriptor(3, this.size);
                f3 = f4 + this.baseline;
            }
        }
        switch (this.codeType) {
            case 1: 
            case 3: 
            case 4: {
                if (this.font == null) break;
                f2 += this.font.getWidthPoint(this.code.charAt(0), this.size);
            }
        }
        byte[] byArray = null;
        int[] nArray = GUARD_EMPTY;
        switch (this.codeType) {
            case 1: {
                byArray = BarcodeEAN.getBarsEAN13(this.code);
                nArray = GUARD_EAN13;
                break;
            }
            case 2: {
                byArray = BarcodeEAN.getBarsEAN8(this.code);
                nArray = GUARD_EAN8;
                break;
            }
            case 3: {
                byArray = BarcodeEAN.getBarsEAN13("0" + this.code);
                nArray = GUARD_UPCA;
                break;
            }
            case 4: {
                byArray = BarcodeEAN.getBarsUPCE(this.code);
                nArray = GUARD_UPCE;
                break;
            }
            case 5: {
                byArray = BarcodeEAN.getBarsSupplemental2(this.code);
                break;
            }
            case 6: {
                byArray = BarcodeEAN.getBarsSupplemental5(this.code);
            }
        }
        float f5 = f2;
        boolean bl = true;
        float f6 = 0.0f;
        if (this.font != null && this.baseline > 0.0f && this.guardBars) {
            f6 = this.baseline / 2.0f;
        }
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            float f7 = (float)byArray[n2] * this.x;
            if (bl) {
                if (Arrays.binarySearch(nArray, n2) >= 0) {
                    pdfContentByte.rectangle(f2, f3 - f6, f7, this.barHeight + f6);
                } else {
                    pdfContentByte.rectangle(f2, f3, f7, this.barHeight);
                }
            }
            bl = !bl;
            f2 += f7;
            ++n2;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            switch (this.codeType) {
                case 1: {
                    pdfContentByte.setTextMatrix(0.0f, f4);
                    pdfContentByte.showText(this.code.substring(0, 1));
                    int n3 = 1;
                    while (n3 < 13) {
                        String string = this.code.substring(n3, n3 + 1);
                        float f8 = this.font.getWidthPoint(string, this.size);
                        float f9 = f5 + TEXTPOS_EAN13[n3 - 1] * this.x - f8 / 2.0f;
                        pdfContentByte.setTextMatrix(f9, f4);
                        pdfContentByte.showText(string);
                        ++n3;
                    }
                    break;
                }
                case 2: {
                    int n4 = 0;
                    while (n4 < 8) {
                        String string = this.code.substring(n4, n4 + 1);
                        float f10 = this.font.getWidthPoint(string, this.size);
                        float f11 = TEXTPOS_EAN8[n4] * this.x - f10 / 2.0f;
                        pdfContentByte.setTextMatrix(f11, f4);
                        pdfContentByte.showText(string);
                        ++n4;
                    }
                    break;
                }
                case 3: {
                    pdfContentByte.setTextMatrix(0.0f, f4);
                    pdfContentByte.showText(this.code.substring(0, 1));
                    int n5 = 1;
                    while (n5 < 11) {
                        String string = this.code.substring(n5, n5 + 1);
                        float f12 = this.font.getWidthPoint(string, this.size);
                        float f13 = f5 + TEXTPOS_EAN13[n5] * this.x - f12 / 2.0f;
                        pdfContentByte.setTextMatrix(f13, f4);
                        pdfContentByte.showText(string);
                        ++n5;
                    }
                    pdfContentByte.setTextMatrix(f5 + this.x * 95.0f, f4);
                    pdfContentByte.showText(this.code.substring(11, 12));
                    break;
                }
                case 4: {
                    pdfContentByte.setTextMatrix(0.0f, f4);
                    pdfContentByte.showText(this.code.substring(0, 1));
                    int n6 = 1;
                    while (n6 < 7) {
                        String string = this.code.substring(n6, n6 + 1);
                        float f14 = this.font.getWidthPoint(string, this.size);
                        float f15 = f5 + TEXTPOS_EAN13[n6 - 1] * this.x - f14 / 2.0f;
                        pdfContentByte.setTextMatrix(f15, f4);
                        pdfContentByte.showText(string);
                        ++n6;
                    }
                    pdfContentByte.setTextMatrix(f5 + this.x * 51.0f, f4);
                    pdfContentByte.showText(this.code.substring(7, 8));
                    break;
                }
                case 5: 
                case 6: {
                    int n7 = 0;
                    while (n7 < this.code.length()) {
                        String string = this.code.substring(n7, n7 + 1);
                        float f16 = this.font.getWidthPoint(string, this.size);
                        float f17 = (7.5f + (float)(9 * n7)) * this.x - f16 / 2.0f;
                        pdfContentByte.setTextMatrix(f17, f4);
                        pdfContentByte.showText(string);
                        ++n7;
                    }
                    break;
                }
            }
            pdfContentByte.endText();
        }
        return rectangle;
    }
}

