/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import java.io.IOException;
import java.io.OutputStream;

public class LZWDecoder {
    byte[][] stringTable;
    byte[] data = null;
    OutputStream uncompData;
    int tableIndex;
    int bitsToGet = 9;
    int bytePointer;
    int bitPointer;
    int nextData = 0;
    int nextBits = 0;
    int[] andTable = new int[]{511, 1023, 2047, 4095};

    public void decode(byte[] byArray, OutputStream outputStream) {
        int n2;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new RuntimeException("LZW flavour not supported.");
        }
        this.initializeStringTable();
        this.data = byArray;
        this.uncompData = outputStream;
        this.bytePointer = 0;
        this.bitPointer = 0;
        this.nextData = 0;
        this.nextBits = 0;
        int n3 = 0;
        while ((n2 = this.getNextCode()) != 257) {
            byte[] byArray2;
            if (n2 == 256) {
                this.initializeStringTable();
                n2 = this.getNextCode();
                if (n2 == 257) break;
                this.writeString(this.stringTable[n2]);
                n3 = n2;
                continue;
            }
            if (n2 < this.tableIndex) {
                byArray2 = this.stringTable[n2];
                this.writeString(byArray2);
                this.addStringToTable(this.stringTable[n3], byArray2[0]);
                n3 = n2;
                continue;
            }
            byArray2 = this.stringTable[n3];
            byArray2 = this.composeString(byArray2, byArray2[0]);
            this.writeString(byArray2);
            this.addStringToTable(byArray2);
            n3 = n2;
        }
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        int n2 = 0;
        while (n2 < 256) {
            this.stringTable[n2] = new byte[1];
            this.stringTable[n2][0] = (byte)n2;
            ++n2;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] byArray) {
        try {
            this.uncompData.write(byArray);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void addStringToTable(byte[] byArray, byte by) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by;
        this.stringTable[this.tableIndex++] = byArray2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] byArray) {
        this.stringTable[this.tableIndex++] = byArray;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] byArray, byte by) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
                this.nextBits += 8;
            }
            int n2 = this.nextData >> this.nextBits - this.bitsToGet & this.andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }
}

