/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ListItem;
import com.lowagie.text.pdf.PdfChunk;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfLine {
    protected ArrayList line = new ArrayList();
    protected float left;
    protected float width;
    protected int alignment;
    protected float height;
    protected PdfChunk listSymbol = null;
    protected float symbolIndent;
    protected boolean newlineSplit = false;
    protected float originalWidth;

    PdfLine(float f2, float f3, int n2, float f4) {
        this.left = f2;
        this.originalWidth = this.width = f3 - f2;
        this.alignment = n2;
        this.height = f4;
    }

    PdfChunk add(PdfChunk pdfChunk) {
        if (pdfChunk == null || pdfChunk.toString().equals("")) {
            return null;
        }
        PdfChunk pdfChunk2 = pdfChunk.split(this.width);
        boolean bl = this.newlineSplit = pdfChunk.isNewlineSplit() || pdfChunk2 == null;
        if (pdfChunk.length() > 0) {
            if (pdfChunk2 != null) {
                pdfChunk.trimLastSpace();
            }
            this.width -= pdfChunk.width();
            this.line.add(pdfChunk);
        } else {
            if (this.line.size() < 1) {
                pdfChunk = pdfChunk2;
                pdfChunk2 = pdfChunk.truncate(this.width);
                this.width -= pdfChunk.width();
                if (pdfChunk.length() > 0) {
                    this.line.add(pdfChunk);
                    return pdfChunk2;
                }
                this.line.add(pdfChunk2);
                return null;
            }
            this.width += ((PdfChunk)this.line.get(this.line.size() - 1)).trimLastSpace();
        }
        return pdfChunk2;
    }

    public int size() {
        return this.line.size();
    }

    public Iterator iterator() {
        return ((AbstractList)this.line).iterator();
    }

    float height() {
        return this.height;
    }

    float indentLeft() {
        switch (this.alignment) {
            case 2: {
                return this.left + this.width;
            }
            case 1: {
                return this.left + this.width / 2.0f;
            }
        }
        return this.left;
    }

    public boolean hasToBeJustified() {
        return this.alignment == 3 && this.width != 0.0f;
    }

    public void resetAlignment() {
        if (this.alignment == 3) {
            this.alignment = 0;
        }
    }

    float widthLeft() {
        return this.width;
    }

    int numberOfSpaces() {
        String string = this.toString();
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (string.charAt(n4) == ' ') {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public void setListItem(ListItem listItem) {
        this.listSymbol = new PdfChunk(listItem.listSymbol(), null);
        this.symbolIndent = listItem.indentationLeft();
    }

    public PdfChunk listSymbol() {
        return this.listSymbol;
    }

    public float listIndent() {
        return this.symbolIndent;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)this.line).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((PdfChunk)iterator.next()).toString());
        }
        return stringBuffer.toString();
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public int getLastStrokeChunk() {
        int n2 = this.line.size() - 1;
        while (n2 >= 0) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(n2);
            if (pdfChunk.isStroked()) break;
            --n2;
        }
        return n2;
    }

    public PdfChunk getChunk(int n2) {
        if (n2 < 0 || n2 >= this.line.size()) {
            return null;
        }
        return (PdfChunk)this.line.get(n2);
    }

    public float getOriginalWidth() {
        return this.originalWidth;
    }

    float getMaxSize() {
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < this.line.size()) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(n2);
            f2 = !pdfChunk.isImage() || !pdfChunk.changeLeading() ? Math.max(pdfChunk.font().size(), f2) : Math.max(pdfChunk.getImage().scaledHeight() + pdfChunk.getImageOffsetY(), f2);
            ++n2;
        }
        return f2;
    }

    float getMaxSizeSimple() {
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < this.line.size()) {
            PdfChunk pdfChunk = (PdfChunk)this.line.get(n2);
            f2 = !pdfChunk.isImage() ? Math.max(pdfChunk.font().size(), f2) : Math.max(pdfChunk.getImage().scaledHeight() + pdfChunk.getImageOffsetY(), f2);
            ++n2;
        }
        return f2;
    }
}

