/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class PolyPolygon
extends EMFTag {
    private Rectangle bounds;
    private int start;
    private int end;
    private int[] numberOfPoints;
    private Point[][] points;

    PolyPolygon() {
        super(8, 1);
    }

    public PolyPolygon(Rectangle bounds, int start, int end, int[] numberOfPoints, Point[][] points) {
        this();
        this.bounds = bounds;
        this.start = start;
        this.end = end;
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle bounds = emf.readRECTL();
        int np = emf.readDWORD();
        int totalNumberOfPoints = emf.readDWORD();
        int[] pc = new int[np];
        Point[][] points = new Point[np][];
        int i2 = 0;
        while (i2 < np) {
            pc[i2] = emf.readDWORD();
            points[i2] = new Point[pc[i2]];
            ++i2;
        }
        int i3 = 0;
        while (i3 < np) {
            points[i3] = emf.readPOINTL(pc[i3]);
            ++i3;
        }
        PolyPolygon tag = new PolyPolygon(bounds, 0, np - 1, pc, points);
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.end - this.start + 1);
        int c2 = 0;
        int i2 = this.start;
        while (i2 < this.end + 1) {
            c2 += this.numberOfPoints[i2];
            ++i2;
        }
        emf.writeDWORD(c2);
        int i3 = this.start;
        while (i3 < this.end + 1) {
            emf.writeDWORD(this.numberOfPoints[i3]);
            ++i3;
        }
        int i4 = this.start;
        while (i4 < this.end + 1) {
            emf.writePOINTL(this.numberOfPoints[i4], this.points[i4]);
            ++i4;
        }
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #polys: " + (this.end - this.start + 1);
    }
}

