/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.examples;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.util.export.ExportDialog;

public class ExportDialogExample
extends JPanel {
    public ExportDialogExample() {
        this.setPreferredSize(new Dimension(600, 400));
    }

    public void paintComponent(Graphics g2) {
        if (g2 == null) {
            return;
        }
        VectorGraphics vg = VectorGraphics.create(g2);
        Dimension dim = this.getSize();
        Insets insets = this.getInsets();
        vg.setColor(Color.white);
        vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
        vg.setColor(Color.black);
        vg.setLineWidth(4.0);
        vg.drawLine(10, 10, dim.width - 10, dim.height - 10);
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("ExportDialogExample");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        final ExportDialogExample panel = new ExportDialogExample();
        frame.getContentPane().add(panel);
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        JMenu file = new JMenu("File");
        menuBar.add(file);
        JMenuItem exportItem = new JMenuItem("Export...");
        exportItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                ExportDialog export = new ExportDialog();
                export.showExportDialog(panel, "Export view as ...", panel, "export");
            }
        });
        file.add(exportItem);
        JMenuItem quitItem = new JMenuItem("Quit");
        quitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                System.exit(0);
            }
        });
        file.add(quitItem);
        frame.pack();
        frame.show();
    }
}

