/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.freehep.graphics2d.TagString;
import org.freehep.graphicsio.MultiPageDocument;

public class HeadFootDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final String[] HF_LABELS = new String[]{"Headline", "Footline"};
    private JTextField[][] textField;
    private JCheckBox[] useCheckBox;
    private TagString[][] text;

    public HeadFootDialog() {
        this.setTitle("Head- and footlines");
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.textField = new JTextField[HF_LABELS.length][];
        this.useCheckBox = new JCheckBox[HF_LABELS.length];
        JPanel textPanel = new JPanel(new GridLayout(HF_LABELS.length * 2, 1));
        int i2 = 0;
        while (i2 < HF_LABELS.length) {
            JPanel title = new JPanel(new FlowLayout(0));
            this.useCheckBox[i2] = new JCheckBox();
            this.useCheckBox[i2].setSelected(false);
            this.useCheckBox[i2].addItemListener(this);
            title.add(this.useCheckBox[i2]);
            title.add(new JLabel(HF_LABELS[i2]));
            textPanel.add(title);
            JPanel textFieldPanel = new JPanel(new FlowLayout());
            this.textField[i2] = new JTextField[3];
            int j2 = 0;
            while (j2 < this.textField[i2].length) {
                this.textField[i2][j2] = new JTextField(10);
                this.textField[i2][j2].setEnabled(false);
                textFieldPanel.add(this.textField[i2][j2]);
                ++j2;
            }
            textPanel.add(textFieldPanel);
            ++i2;
        }
        this.getContentPane().add((Component)textPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("cancel");
        cancel.addActionListener(this);
        buttonPanel.add(cancel);
        JButton ok = new JButton("Ok");
        ok.setActionCommand("ok");
        ok.addActionListener(this);
        buttonPanel.add(ok);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.text = new TagString[this.useCheckBox.length][];
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getActionCommand().equals("ok")) {
            int i2 = 0;
            while (i2 < this.useCheckBox.length) {
                if (this.useCheckBox[i2].isSelected()) {
                    this.text[i2] = new TagString[3];
                    int j2 = 0;
                    while (j2 < this.textField[i2].length) {
                        this.text[i2][j2] = new TagString(this.textField[i2][j2].getText());
                        ++j2;
                    }
                } else {
                    this.text[i2] = null;
                }
                ++i2;
            }
            this.hide();
        } else if (e2.getActionCommand().equals("cancel")) {
            int i3 = 0;
            while (i3 < this.useCheckBox.length) {
                this.useCheckBox[i3].setSelected(this.text[i3] != null);
                int j3 = 0;
                while (j3 < this.textField[i3].length) {
                    if (this.text[i3] != null) {
                        this.textField[i3][j3].setText(this.text[i3][j3].toString());
                        this.textField[i3][j3].setEnabled(true);
                    } else {
                        this.textField[i3][j3].setText("");
                        this.textField[i3][j3].setEnabled(false);
                    }
                    ++j3;
                }
                ++i3;
            }
            this.hide();
        }
    }

    public void configure(MultiPageDocument md) {
        if (this.text[0] != null) {
            md.setHeader(new Font("times", 0, 10), this.text[0][0], this.text[0][1], this.text[0][2], 1);
        }
        if (this.text[1] != null) {
            md.setFooter(new Font("times", 0, 10), this.text[1][0], this.text[1][1], this.text[1][2], 1);
        }
    }

    public void itemStateChanged(ItemEvent e2) {
        int i2 = 0;
        while (i2 < this.useCheckBox.length) {
            if (e2.getSource() == this.useCheckBox[i2]) {
                int j2 = 0;
                while (j2 < this.textField[i2].length) {
                    this.textField[i2][j2].setEnabled(e2.getStateChange() == 1);
                    ++j2;
                }
            }
            ++i2;
        }
    }

    public static void main(String[] argv) {
        HeadFootDialog d2 = new HeadFootDialog();
        d2.show();
    }
}

