/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFTable;

public class TTFNameTable
extends TTFTable {
    private int format;
    private int numberOfNameRecords;
    private int stringStorage;
    private String[][] name = new String[4][19];

    public String getTag() {
        return "name";
    }

    public void readTable() throws IOException {
        this.format = this.ttf.readUShort();
        this.numberOfNameRecords = this.ttf.readUShort();
        this.stringStorage = this.ttf.readUShort();
        int i2 = 0;
        while (i2 < this.numberOfNameRecords) {
            int pid = this.ttf.readUShort();
            int eid = this.ttf.readUShort();
            int lid = this.ttf.readUShort();
            int nid = this.ttf.readUShort();
            int stringLen = this.ttf.readUShort();
            int stringOffset = this.ttf.readUShort();
            this.ttf.pushPos();
            this.ttf.seek(this.stringStorage + stringOffset);
            byte[] b2 = new byte[stringLen];
            this.ttf.readFully(b2);
            if (pid == 0) {
                this.name[pid][nid] = new String(b2, "UnicodeBig");
            } else if (pid == 1 && eid == 0) {
                if (lid == 0) {
                    this.name[pid][nid] = new String(b2, "ISO8859-1");
                }
            } else if (pid == 3 && eid == 1) {
                if (lid == 1033) {
                    this.name[pid][nid] = new String(b2, "UnicodeBig");
                }
            } else {
                System.out.println("Unimplemented PID, EID, LID scheme: " + pid + ", " + eid + ", " + lid);
                System.out.println("NID = " + nid);
                this.name[pid][nid] = new String(b2, "Default");
            }
            this.ttf.popPos();
            ++i2;
        }
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append(super.toString() + "\n");
        s2.append("  format: " + this.format);
        int i2 = 0;
        while (i2 < this.name.length) {
            int j2 = 0;
            while (j2 < this.name[i2].length) {
                if (this.name[i2][j2] != null) {
                    s2.append("\n  name[" + i2 + "][" + j2 + "]: " + this.name[i2][j2]);
                }
                ++j2;
            }
            ++i2;
        }
        return s2.toString();
    }
}

