/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Color;
import org.freehep.graphicsio.ps.ColorMap;

public class MappedColor
extends Color {
    protected int colorIndex;
    protected int brightness;

    public MappedColor(int r2, int g2, int b2, int colorIndex) {
        super(r2, g2, b2);
        this.colorIndex = colorIndex;
        this.brightness = 0;
    }

    public MappedColor(int r2, int g2, int b2, int colorIndex, int brightness) {
        super(r2, g2, b2);
        this.colorIndex = colorIndex;
        this.brightness = brightness;
    }

    public Color brighter() {
        int r2 = this.getRed() * 10 / 7;
        int g2 = this.getGreen() * 10 / 7;
        int b2 = this.getBlue() * 10 / 7;
        r2 = Math.max(0, Math.min(255, r2));
        g2 = Math.max(0, Math.min(255, g2));
        b2 = Math.max(0, Math.min(255, b2));
        return new MappedColor(r2, g2, b2, this.colorIndex, this.brightness - 1);
    }

    public Color darker() {
        int r2 = this.getRed() * 7 / 10;
        int g2 = this.getGreen() * 7 / 10;
        int b2 = this.getBlue() * 7 / 10;
        r2 = Math.max(0, Math.min(255, r2));
        g2 = Math.max(0, Math.min(255, g2));
        b2 = Math.max(0, Math.min(255, b2));
        return new MappedColor(r2, g2, b2, this.colorIndex, this.brightness - 1);
    }

    public int getBrightness() {
        return this.brightness;
    }

    public String getColorTag() {
        return ColorMap.getTag(this.colorIndex);
    }
}

