/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.freehep.graphicsio.font.FontEmbedder;
import org.freehep.graphicsio.font.FontEmbedderType1;
import org.freehep.graphicsio.font.FontIncluder;
import org.freehep.graphicsio.font.FontTable;
import org.freehep.graphicsio.font.encoding.CharTable;
import org.freehep.graphicsio.font.encoding.Lookup;
import org.freehep.graphicsio.ps.PSFontEmbedder;

public class PSFontTable
extends FontTable {
    private OutputStream out;
    private FontRenderContext context;
    private static final Properties psFontNames = new Properties();

    public PSFontTable(OutputStream out, FontRenderContext context) {
        this.out = out;
        this.context = context;
    }

    public CharTable getEncodingTable() {
        return Lookup.getInstance().getTable("STDLatin");
    }

    protected void firstRequest(FontTable.Entry e2, boolean embed, String embedAs) throws IOException {
        FontEmbedder fontIncluder = null;
        e2.setWritten(true);
        this.out.flush();
        if (embed) {
            if (embedAs.equals("Type3")) {
                fontIncluder = new PSFontEmbedder(this.context, new PrintStream(this.out));
            } else if (embedAs.equals("Type1")) {
                fontIncluder = new FontEmbedderType1(this.context, this.out, true);
            } else {
                System.err.println("PSFontTable: not a valid value for embedAs: " + embedAs);
            }
        } else {
            return;
        }
        ((FontIncluder)fontIncluder).includeFont(e2.getFont(), e2.getEncoding(), e2.getReference());
        this.out.flush();
    }

    private static boolean isStandardFont(Font font) {
        String fontName = font.getName().toLowerCase();
        return fontName.indexOf("helvetica") >= 0 || fontName.indexOf("avantgarde") >= 0 || fontName.indexOf("bookman") >= 0 || fontName.indexOf("courier") >= 0 || fontName.indexOf("newcenturysclbk") >= 0 || fontName.indexOf("palatino") >= 0 || fontName.indexOf("times") >= 0 || fontName.indexOf("zapfdingbats") >= 0 || fontName.indexOf("zapfchancery") >= 0 || fontName.indexOf("symbol") >= 0;
    }

    protected Font substituteFont(Font font) {
        return font;
    }

    protected String createFontReference(Font font) {
        String fontName = font.getName();
        StringBuffer psFontName = new StringBuffer();
        int i2 = 0;
        while (i2 < fontName.length()) {
            char c2 = fontName.charAt(i2);
            if (!Character.isWhitespace(c2)) {
                psFontName.append(c2);
            }
            ++i2;
        }
        boolean hyphen = false;
        if (font.isBold()) {
            hyphen = true;
            psFontName.append("-Bold");
        }
        if (font.isItalic()) {
            psFontName.append((hyphen ? "" : "-") + "Italic");
        }
        fontName = psFontName.toString();
        fontName = psFontNames.getProperty(fontName, fontName);
        return fontName;
    }

    static {
        psFontNames.setProperty("TimesRoman", "Times-Roman");
        psFontNames.setProperty("TimesRoman-Italic", "Times-Italic");
        psFontNames.setProperty("TimesRoman-Bold", "Times-Bold");
        psFontNames.setProperty("TimesRoman-BoldItalic", "Times-BoldItalic");
        psFontNames.setProperty("Helvetica-Italic", "Helvetica-Oblique");
        psFontNames.setProperty("Helvetica-BoldItalic", "Helvetica-BoldOblique");
        psFontNames.setProperty("Courier-Italic", "Courier-Oblique");
        psFontNames.setProperty("Courier-BoldItalic", "Courier-BoldOblique");
        psFontNames.setProperty("Avantgarde-Italic", "Avantgarde-Oblique");
        psFontNames.setProperty("Avantgarde-BoldItalic", "Avantgarde-BoldOblique");
        psFontNames.setProperty("Symbol-Italic", "Symbol");
        psFontNames.setProperty("Symbol-Bold", "Symbol");
        psFontNames.setProperty("Symbol-BoldItalic", "Symbol");
        psFontNames.setProperty("ZapfDingbats-Italic", "ZapfDingbats");
        psFontNames.setProperty("ZapfDingbats-Bold", "ZapfDingbats");
        psFontNames.setProperty("ZapfDingbats-BoldItalic", "ZapfDingbats");
    }
}

