/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.freehep.graphicsio.swf.LineStyle;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class LineStyleArray {
    protected List lineStyles = new ArrayList();

    public LineStyleArray() {
    }

    public LineStyleArray(SWFInputStream swf, boolean isMorphStyle, boolean hasAlpha) throws IOException {
        this();
        int lineStyleCount = swf.readUnsignedByte();
        if (lineStyleCount == 255) {
            lineStyleCount = swf.readUnsignedShort();
        }
        int i2 = 0;
        while (i2 < lineStyleCount) {
            this.lineStyles.add(new LineStyle(swf, isMorphStyle, hasAlpha));
            ++i2;
        }
    }

    public void add(LineStyle lineStyle) {
        this.lineStyles.add(lineStyle);
    }

    public LineStyle get(int index) {
        return (LineStyle)this.lineStyles.get(index);
    }

    public void write(SWFOutputStream swf, boolean hasAlpha) throws IOException {
        if (this.lineStyles.size() >= 255) {
            swf.writeUnsignedByte(255);
            swf.writeUnsignedShort(this.lineStyles.size());
        } else {
            swf.writeUnsignedByte(this.lineStyles.size());
        }
        Iterator i2 = this.lineStyles.iterator();
        while (i2.hasNext()) {
            ((LineStyle)i2.next()).write(swf, hasAlpha);
        }
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append("  lineStyles: " + this.lineStyles.size() + "\n");
        int n2 = 0;
        Iterator i2 = this.lineStyles.iterator();
        while (i2.hasNext()) {
            s2.append("    " + (n2 + 1) + " " + i2.next() + "\n");
            ++n2;
        }
        return s2.toString();
    }
}

