/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.preview;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.preview.TextLabel;

public class LabelPlacer
extends Component {
    Vector labels = new Vector();
    Random xRandom = new Random();
    Random yRandom = new Random();
    Random locRandom = new Random();
    int border = 50;
    static Label labelCount = new Label("# of Labels: 00");
    static Label conflictCount = new Label("# of Conflicts: 00");
    static Label temperature = new Label("T: 00");
    static Label stageCount = new Label("Stage: 50");

    public LabelPlacer() {
        this.setBackground(Color.black);
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 640);
    }

    public void paint(Graphics g2) {
        VectorGraphics g1 = VectorGraphics.create(g2);
        Rectangle d2 = this.getBounds();
        g1.setColor(this.getBackground());
        g1.fillRect(d2.x, d2.y, d2.width, d2.height);
        g1.setColor(this.getForeground());
        Enumeration e2 = this.labels.elements();
        while (e2.hasMoreElements()) {
            TextLabel label = (TextLabel)e2.nextElement();
            int hor = label.getAlignmentX();
            int ver = label.getAlignmentY();
            int x2 = label.getX();
            int y2 = label.getY();
            if (label.getConflicts() > 0) {
                g1.setColor(Color.cyan);
            } else {
                g1.setColor(Color.white);
            }
            Rectangle r2 = label.getBounds();
            g1.drawRect(this.border + r2.x, this.border + r2.y, r2.width, r2.height);
            g1.drawString(label.getText(), (double)(this.border + x2), (double)(this.border + y2), hor, ver);
            g1.setColor(Color.red);
            g1.fillRect(this.border + x2 - 1, this.border + y2 - 1, 3, 3);
        }
    }

    private void addLabels(int n2) {
        Dimension d2 = this.getSize();
        while (n2 > 0) {
            this.labels.addElement(new TextLabel("Point " + this.labels.size(), new Point(this.xRandom.nextInt(d2.width - 2 * this.border), this.yRandom.nextInt(d2.height - 2 * this.border)), this.locRandom.nextInt(8), this));
            --n2;
        }
        this.setConflicts();
        this.keep();
        labelCount.setText("# of Labels: " + this.labels.size());
    }

    private void positionLabels(int algorithm) {
        block1 : switch (algorithm) {
            case 1: {
                int oldConflicts = this.countConflicts();
                int i2 = 0;
                while (i2 < this.labels.size()) {
                    TextLabel ref = (TextLabel)this.labels.elementAt(i2);
                    ref.tmpPosition = this.locRandom.nextInt(8);
                    ++i2;
                }
                if (this.setConflicts() >= oldConflicts) break;
                this.keep();
                break;
            }
            case 2: {
                int oldConflicts = this.countConflicts();
                int i3 = 0;
                while (i3 < this.labels.size()) {
                    TextLabel ref = (TextLabel)this.labels.elementAt(i3);
                    if (ref.tmpConflicts > 0) {
                        int oldPosition = ref.tmpPosition;
                        int[] pos = LabelPlacer.generateSequence(oldPosition);
                        int posIndex = 0;
                        while (posIndex < 7 && ref.tmpConflicts > 0) {
                            int newPosition = pos[posIndex];
                            ++posIndex;
                            this.moveLabel(i3, newPosition);
                        }
                    }
                    ++i3;
                }
                if (this.setConflicts() >= oldConflicts) break;
                this.keep();
                break;
            }
            case 3: {
                int E;
                Random labelPicker = new Random();
                Random undo = new Random();
                Random posPicker = new Random();
                int lowestE = E = this.setConflicts();
                double T = -1.0 / Math.log(0.33333333333333337);
                temperature.setText("T: " + (int)(T * 100.0));
                int moved = 0;
                int maxMoved = this.labels.size() * 20;
                int success = 0;
                int maxSuccess = this.labels.size() * 5;
                int stages = 50;
                stageCount.setText("Stage: " + stages);
                while (E > 0 && stages > 0) {
                    if (moved > maxMoved || success > maxSuccess) {
                        if (success == 0) {
                            System.out.println("No successes at all at tis temp");
                            break block1;
                        }
                        moved = 0;
                        success = 0;
                        temperature.setText("T: " + (int)((T *= 0.9) * 100.0));
                        stageCount.setText("Stage: " + --stages);
                    }
                    int index = labelPicker.nextInt(this.labels.size());
                    TextLabel label = (TextLabel)this.labels.elementAt(index);
                    int newPosition = posPicker.nextInt(8);
                    if (newPosition >= label.tmpPosition) {
                        newPosition = (newPosition + 1) % 8;
                    }
                    int dE = this.getDeltaE(index, newPosition);
                    double P = 1.0;
                    if (dE > 0) {
                        P = 1.0 - Math.exp((double)(-dE) / T);
                        if (undo.nextDouble() > P) {
                            this.moveLabel(index, newPosition);
                            E += dE;
                        }
                    } else {
                        this.moveLabel(index, newPosition);
                        ++success;
                        E += dE;
                    }
                    ++moved;
                    if (E >= lowestE) continue;
                    System.out.println("S=" + stages + ", T=" + T + ", E=" + E + ", dE=" + dE + ", P=" + P + ", m=" + moved + ", s=" + success);
                    lowestE = E;
                    System.out.println(this.keep());
                    this.repaint();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                break;
            }
            default: {
                System.out.println("Algorithm#: " + algorithm + " not implemented");
            }
        }
    }

    private int setConflicts() {
        int conflicts = 0;
        int i2 = 0;
        while (i2 < this.labels.size()) {
            TextLabel ref = (TextLabel)this.labels.elementAt(i2);
            ref.tmpConflicts = 0;
            Rectangle refRect = ref.getBounds(ref.tmpPosition);
            int j2 = 0;
            while (j2 < this.labels.size()) {
                TextLabel label;
                Rectangle labelRect;
                if (i2 != j2 && (labelRect = (label = (TextLabel)this.labels.elementAt(j2)).getBounds(label.tmpPosition)).intersects(refRect)) {
                    ++ref.tmpConflicts;
                    ++conflicts;
                }
                ++j2;
            }
            ++i2;
        }
        return conflicts;
    }

    private int countConflicts() {
        int conflicts = 0;
        int i2 = 0;
        while (i2 < this.labels.size()) {
            TextLabel ref = (TextLabel)this.labels.elementAt(i2);
            conflicts += ref.getConflicts();
            ++i2;
        }
        return conflicts;
    }

    private int keep() {
        int conflicts = 0;
        int i2 = 0;
        while (i2 < this.labels.size()) {
            TextLabel ref = (TextLabel)this.labels.elementAt(i2);
            conflicts += ref.keep();
            ++i2;
        }
        conflictCount.setText("# of Conflicts: " + conflicts / 2);
        return conflicts;
    }

    private int getDeltaE(int index, int newPosition) {
        int oldConflicts = 0;
        int newConflicts = 0;
        TextLabel ref = (TextLabel)this.labels.elementAt(index);
        Rectangle oldRect = ref.getBounds(ref.tmpPosition);
        Rectangle newRect = ref.getBounds(newPosition);
        int i2 = 0;
        while (i2 < this.labels.size()) {
            if (i2 != index) {
                TextLabel label = (TextLabel)this.labels.elementAt(i2);
                Rectangle labelRect = label.getBounds(label.tmpPosition);
                boolean oldIntersects = labelRect.intersects(oldRect);
                boolean newIntersects = labelRect.intersects(newRect);
                if (oldIntersects) {
                    oldConflicts += 2;
                    if (newIntersects) {
                        newConflicts += 2;
                    }
                } else if (newIntersects) {
                    newConflicts += 2;
                }
            }
            ++i2;
        }
        return newConflicts - oldConflicts;
    }

    private void moveLabel(int index, int newPosition) {
        TextLabel ref = (TextLabel)this.labels.elementAt(index);
        Rectangle oldRect = ref.getBounds(ref.tmpPosition);
        ref.tmpPosition = newPosition;
        Rectangle newRect = ref.getBounds(ref.tmpPosition);
        int i2 = 0;
        while (i2 < this.labels.size()) {
            if (i2 != index) {
                TextLabel label = (TextLabel)this.labels.elementAt(i2);
                Rectangle labelRect = label.getBounds(label.tmpPosition);
                boolean oldIntersects = labelRect.intersects(oldRect);
                boolean newIntersects = labelRect.intersects(newRect);
                if (oldIntersects) {
                    if (!newIntersects) {
                        if (ref.tmpConflicts > 0) {
                            --ref.tmpConflicts;
                        } else {
                            System.out.println("Old conflict was not counted in ref: " + index);
                        }
                        if (label.tmpConflicts > 0) {
                            --label.tmpConflicts;
                        } else {
                            System.out.println("Old conflict was not counted in label: " + i2);
                        }
                    }
                } else if (newIntersects) {
                    ++ref.tmpConflicts;
                    ++label.tmpConflicts;
                }
            }
            ++i2;
        }
    }

    private static int[] generateSequence(int avoidPosition) {
        Random sequencer = new Random();
        boolean[] done = new boolean[8];
        done[avoidPosition] = true;
        int[] seq = new int[7];
        int i2 = 0;
        while (i2 < 7) {
            int index = sequencer.nextInt(7 - i2) + 1;
            int r2 = 0;
            int j2 = -1;
            while (j2 < 7 && r2 < index) {
                if (done[++j2]) continue;
                ++r2;
            }
            seq[i2] = j2;
            done[seq[i2]] = true;
            ++i2;
        }
        return seq;
    }

    public static void main(String[] args) {
        Frame frame;
        Frame content = frame = new Frame();
        content.setLayout(new BorderLayout());
        final LabelPlacer lp = new LabelPlacer();
        content.add((Component)lp, "Center");
        Panel p2 = new Panel();
        content.add((Component)p2, "South");
        p2.add(labelCount);
        p2.add(conflictCount);
        Button b2 = new Button("Add 10 more labels");
        p2.add(b2);
        b2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                lp.addLabels(10);
                lp.repaint();
            }
        });
        b2 = new Button("Randomize Positions");
        p2.add(b2);
        b2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                lp.positionLabels(1);
                lp.repaint();
            }
        });
        b2 = new Button("Greedy Positions");
        p2.add(b2);
        b2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                lp.positionLabels(2);
                lp.repaint();
            }
        });
        b2 = new Button("Simulated Annealing Positions");
        p2.add(b2);
        b2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                Thread t2 = new Thread(this){
                    private final /* synthetic */ 4 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        LabelPlacer.access$100(4.access$200(this.this$0), 3);
                        4.access$200(this.this$0).repaint();
                    }
                };
                t2.start();
            }

            static /* synthetic */ LabelPlacer access$200(4 x0) {
                return x0.lp;
            }
        });
        p2.add(stageCount);
        p2.add(temperature);
        frame.pack();
        frame.show();
        lp.addLabels(100);
        lp.repaint();
    }
}

