/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.SwingUtilities;
import org.freehep.swing.graphics.GraphicalSelectionEvent;
import org.freehep.swing.graphics.GraphicalSelectionPanel;
import org.freehep.swing.graphics.RegionSelectionEvent;
import org.freehep.swing.images.FreeHepImage;

public abstract class AbstractRegionSelectionPanel
extends GraphicalSelectionPanel {
    public static final int NO_CONTROL_POINT = -1;
    protected boolean visibleGuides;
    protected Rectangle rectToDraw = new Rectangle();
    protected Rectangle lastDrawnRect = new Rectangle();
    protected Rectangle updateRect = new Rectangle();
    protected boolean visible = false;
    protected boolean lastDrawnRectValid = false;
    protected int hitThreshold = 10;
    protected static int ctrlPtSize = 1;
    protected int nCtrlPts;
    protected int activeCtrlPt;
    protected int[] xCtrlPts;
    protected int[] yCtrlPts;

    public AbstractRegionSelectionPanel() {
        this.setSelectionActionsEnabled(false);
        this.visibleGuides = true;
        this.nCtrlPts = Math.max(4, this.getNumberOfControlPoints());
        this.xCtrlPts = new int[this.nCtrlPts];
        this.yCtrlPts = new int[this.nCtrlPts];
        this.activeCtrlPt = -1;
        this.setCursor();
    }

    public void setVisibleGuides(boolean visibleGuides) {
        this.visibleGuides = visibleGuides;
        this.repaintPanel();
    }

    public boolean getVisibleGuides() {
        return this.visibleGuides;
    }

    public void keyReleased(KeyEvent e2) {
        int increment = e2.isShiftDown() ? 1 : 2;
        switch (e2.getKeyCode()) {
            case 38: {
                this.moveActiveControlPoint(0, -increment);
                break;
            }
            case 40: {
                this.moveActiveControlPoint(0, increment);
                break;
            }
            case 39: {
                this.moveActiveControlPoint(increment, 0);
                break;
            }
            case 37: {
                this.moveActiveControlPoint(-increment, 0);
                break;
            }
            default: {
                super.keyReleased(e2);
            }
        }
    }

    protected void makeSelectionEvent(int actionCode) {
        switch (actionCode) {
            case 13: {
                this.resetSelection();
                this.setVisible(false);
                this.fireGraphicalSelectionMade(new GraphicalSelectionEvent(this, 13, null, null));
                break;
            }
            case 10: {
                this.resetSelection();
                this.setVisible(false);
                this.fireGraphicalSelectionMade(new GraphicalSelectionEvent(this, 10, null, null));
                break;
            }
            case 11: {
                this.resetSelection();
                this.setVisible(false);
                this.fireGraphicalSelectionMade(new GraphicalSelectionEvent(this, 11, null, null));
                break;
            }
            default: {
                if (this.visible) {
                    Point[] points = new Point[4];
                    int i2 = 0;
                    while (i2 < 4) {
                        points[i2] = new Point(this.xCtrlPts[i2], this.yCtrlPts[i2]);
                        ++i2;
                    }
                    this.fireGraphicalSelectionMade(new RegionSelectionEvent((Object)this, actionCode, this.makeOutlinePolygon(), this.makeAffineTransform()));
                }
                this.resetSelection();
            }
        }
    }

    private void setCursor() {
        Cursor cursor = this.getControlPointCursor(this.activeCtrlPt);
        if (cursor == null) {
            cursor = this.getControlPointCursor(-1);
        }
        if (cursor != null) {
            this.setCursor(cursor);
        }
    }

    public void mouseMoved(MouseEvent e2) {
        int newCtrlPt;
        if (!this.isProcessingPopup(e2) && this.visible && (newCtrlPt = this.nearWhichControlPoint(e2.getX(), e2.getY(), this.hitThreshold)) != this.activeCtrlPt) {
            this.activeCtrlPt = newCtrlPt;
            this.setCursor();
            this.repaintPanel();
            return;
        }
    }

    public void mousePressed(MouseEvent e2) {
        if (!this.isProcessingPopup(e2)) {
            int newCtrlPt;
            if (this.visible && (newCtrlPt = this.nearWhichControlPoint(e2.getX(), e2.getY(), this.hitThreshold)) >= 0) {
                this.activeCtrlPt = newCtrlPt;
                this.setCursor();
                this.repaintPanel();
                return;
            }
            this.visible = true;
            this.setSelectionActionsEnabled(true);
            int x2 = this.forceXCoordinateWithinBounds(e2.getX());
            int y2 = this.forceYCoordinateWithinBounds(e2.getY());
            this.activeCtrlPt = -1;
            this.initializeControlPoints(x2, y2);
            this.setCursor();
            this.repaintPanel();
        }
    }

    public int forceXCoordinateWithinBounds(int x2) {
        int xmin = 0;
        int xmax = this.getWidth() - 1;
        return Math.max(Math.min(x2, xmax), xmin);
    }

    public int forceYCoordinateWithinBounds(int y2) {
        int ymin = 0;
        int ymax = this.getHeight() - 1;
        return Math.max(Math.min(y2, ymax), ymin);
    }

    public void mouseDragged(MouseEvent e2) {
        if (!this.isProcessingPopup(e2)) {
            this.updateActiveControlPoint(e2.getX(), e2.getY());
            this.setCursor();
        }
    }

    public void mouseReleased(MouseEvent e2) {
        if (!this.isProcessingPopup(e2)) {
            this.updateActiveControlPoint(e2.getX(), e2.getY());
            if (!this.isValidSelection()) {
                this.resetSelection();
            }
            this.setCursor();
        } else {
            this.activeCtrlPt = -1;
            this.setCursor();
        }
    }

    public abstract boolean isValidSelection();

    protected void moveActiveControlPoint(int dx, int dy) {
        if (this.activeCtrlPt >= 0) {
            int x2 = this.xCtrlPts[this.activeCtrlPt] + dx;
            int y2 = this.yCtrlPts[this.activeCtrlPt] + dy;
            this.updateActiveControlPoint(x2, y2);
        }
    }

    protected int nearWhichControlPoint(int x2, int y2, int maxDist) {
        int nearestCtrlPt = -1;
        int minDist2 = -1;
        int i2 = 0;
        while (i2 < this.nCtrlPts) {
            int dx = x2 - this.xCtrlPts[i2];
            int dy = y2 - this.yCtrlPts[i2];
            int dist = dx * dx + dy * dy;
            if (dist < minDist2 || i2 == 0) {
                minDist2 = dist;
                nearestCtrlPt = i2;
            }
            ++i2;
        }
        if (minDist2 > maxDist * maxDist) {
            nearestCtrlPt = -1;
        }
        return nearestCtrlPt;
    }

    public void resetSelection() {
        this.visible = false;
        this.lastDrawnRectValid = false;
        this.setSelectionActionsEnabled(false);
        this.activeCtrlPt = -1;
        this.setCursor();
        this.repaintPanel();
    }

    protected void repaintPanel() {
        int x0 = this.xCtrlPts[0];
        int y0 = this.yCtrlPts[0];
        int x1 = this.xCtrlPts[0];
        int y1 = this.yCtrlPts[0];
        int i2 = 1;
        while (i2 < this.nCtrlPts) {
            if (this.xCtrlPts[i2] < x0) {
                x0 = this.xCtrlPts[i2];
            }
            if (this.yCtrlPts[i2] < y0) {
                y0 = this.yCtrlPts[i2];
            }
            if (this.xCtrlPts[i2] > x1) {
                x1 = this.xCtrlPts[i2];
            }
            if (this.yCtrlPts[i2] > y1) {
                y1 = this.yCtrlPts[i2];
            }
            ++i2;
        }
        this.rectToDraw.setRect(x0 -= ctrlPtSize + 2, y0 -= ctrlPtSize + 2, (x1 += ctrlPtSize + 2) - x0, (y1 += ctrlPtSize + 2) - y0);
        this.updateRect.setBounds(this.rectToDraw);
        if (this.lastDrawnRectValid) {
            this.updateRect = SwingUtilities.computeUnion(this.lastDrawnRect.x, this.lastDrawnRect.y, this.lastDrawnRect.width, this.lastDrawnRect.height, this.updateRect);
        }
        this.repaint(this.updateRect);
    }

    public abstract void initializeControlPoints(int var1, int var2);

    public abstract void updateActiveControlPoint(int var1, int var2);

    public abstract int getNumberOfControlPoints();

    public Cursor getControlPointCursor(int index) {
        return null;
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.lastDrawnRectValid = true;
        this.lastDrawnRect.setBounds(this.rectToDraw);
    }

    public Polygon makeOutlinePolygon() {
        Polygon polygon = new Polygon();
        int i2 = 0;
        while (i2 < 4) {
            polygon.addPoint(this.xCtrlPts[i2], this.yCtrlPts[i2]);
            ++i2;
        }
        return polygon;
    }

    public abstract AffineTransform makeAffineTransform();

    protected AffineTransform makeTransform(double x0, double y0, double x1, double y1, double x2, double y2) {
        double sx = 0.0;
        double kx = 0.0;
        double tx = 0.0;
        double sy = 0.0;
        double ky = 0.0;
        double ty = 0.0;
        double delta = x2 * (y1 - y0) - x1 * (y2 - y0) + x0 * (y2 - y1);
        if (delta == 0.0) {
            return null;
        }
        delta = 1.0 / delta;
        double w2 = this.getWidth();
        double h2 = this.getHeight();
        sx = -(delta * w2) * (y2 - y1);
        kx = delta * w2 * (x2 - x1);
        tx = -(x0 * sx + y0 * kx);
        ky = delta * h2 * (y1 - y0);
        sy = -(delta * h2) * (x1 - x0);
        ty = -(x0 * ky + y0 * sy);
        return new AffineTransform(sx, ky, kx, sy, tx, ty);
    }

    public static Cursor compassCursor(String type, int dx, int dy, int n2, boolean diagonal) {
        double offset;
        if (dx == 0 && dy == 0) {
            return null;
        }
        if (n2 == 4) {
            offset = diagonal ? 0.0 : 0.7853981633974483;
        } else {
            n2 = 8;
            offset = 0.39269908169872414;
        }
        double delta = Math.PI * 2 / (double)n2;
        double alpha = (Math.atan2(-dy, dx) + Math.PI * 2 + offset) % (Math.PI * 2);
        int d2 = (int)(alpha / delta);
        if (n2 == 4) {
            d2 = diagonal ? d2 * 2 + 1 : d2 * 2;
        }
        switch (d2) {
            case 0: {
                return FreeHepImage.getCursor("E_" + type + "Cursor", 16, 16);
            }
            case 1: {
                return FreeHepImage.getCursor("NE_" + type + "Cursor", 16, 16);
            }
            case 2: {
                return FreeHepImage.getCursor("N_" + type + "Cursor", 16, 16);
            }
            case 3: {
                return FreeHepImage.getCursor("NW_" + type + "Cursor", 16, 16);
            }
            case 4: {
                return FreeHepImage.getCursor("W_" + type + "Cursor", 16, 16);
            }
            case 5: {
                return FreeHepImage.getCursor("SW_" + type + "Cursor", 16, 16);
            }
            case 6: {
                return FreeHepImage.getCursor("S_" + type + "Cursor", 16, 16);
            }
            case 7: {
                return FreeHepImage.getCursor("SE_" + type + "Cursor", 16, 16);
            }
        }
        System.err.println("compassCursor invalid value: " + d2);
        return Cursor.getDefaultCursor();
    }
}

