/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.geom.GeneralPath;

public class Scale {
    private static int[] p = new int[]{2, 2, 5, 5, 5, 10, 10, 10, 20, 20, 50, 50};
    private static int[] ps = new int[]{2, 10, 5, 10, 20, 10, 20, 50, 20, 100, 50, 100};
    public static final int LEFT_TICKS = 0;
    public static final int RIGHT_TICKS = 1;
    public static final int BOTH_TICKS = 2;
    protected static float primaryTickSize = 8.0f;
    protected static float secondaryTickSize = 5.0f;

    public static void setTickSizes(float primaryTickSize, float secondaryTickSize) {
        Scale.primaryTickSize = primaryTickSize;
        Scale.secondaryTickSize = secondaryTickSize;
    }

    public static float getPrimaryTickSize() {
        return primaryTickSize;
    }

    public static float getSecondaryTickSize() {
        return secondaryTickSize;
    }

    private static void addTickMark(GeneralPath gp, int location, float tickPosition, float tickLength) {
        switch (location) {
            case 1: {
                gp.moveTo(tickPosition, 0.0f);
                gp.lineTo(tickPosition, tickLength);
                break;
            }
            case 0: {
                gp.moveTo(tickPosition, 0.0f);
                gp.lineTo(tickPosition, -tickLength);
                break;
            }
            case 2: {
                gp.moveTo(tickPosition, -tickLength);
                gp.lineTo(tickPosition, tickLength);
            }
        }
    }

    public static void drawLinearScale(double value0, double value1, int scaleSize, int minPrimary, int minSeparation, int location, GeneralPath primaryTicks, GeneralPath secondaryTicks, String[] label, double[] position) {
        double range = Math.abs(value1 - value0);
        int sign = value1 - value0 > 0.0 ? 1 : -1;
        double m2 = Math.pow(10.0, Math.ceil(Math.log(range) / Math.log(10.0)));
        double w2 = scaleSize;
        double minNP = m2 * (double)minPrimary / range;
        double maxNPNS = w2 * m2 / (range * (double)minSeparation);
        int optimal = -1;
        int oldPS = -1;
        int oldP = Integer.MAX_VALUE;
        int i2 = 0;
        while (i2 < p.length) {
            if ((double)p[i2] > minNP && (double)ps[i2] < maxNPNS && p[i2] <= oldP && ps[i2] > oldPS) {
                optimal = i2;
                oldP = p[i2];
                oldPS = ps[i2];
            }
            ++i2;
        }
        primaryTicks.reset();
        secondaryTicks.reset();
        primaryTicks.moveTo(0.0f, 0.0f);
        primaryTicks.lineTo((float)w2, 0.0f);
        secondaryTicks.moveTo(0.0f, 0.0f);
        secondaryTicks.lineTo((float)w2, 0.0f);
        if (optimal > 0) {
            int iv;
            double size = m2 / (double)ps[optimal];
            int average = (int)(0.5 * (value0 + value1) / size);
            int limit0 = (int)(value0 / size - (double)average) + average;
            int limit1 = (int)(value1 / size - (double)average) + average;
            int iv2 = Math.min(limit0, limit1);
            while (iv2 <= Math.max(limit0, limit1)) {
                double val = (double)iv2 * size;
                float tickPosition = Scale.interpolate(val, w2, value0, value1);
                Scale.addTickMark(secondaryTicks, location, tickPosition, secondaryTickSize);
                ++iv2;
            }
            size = m2 / (double)p[optimal];
            average = (int)(0.5 * (value0 + value1) / size);
            limit0 = (int)(value0 / size - (double)average) + average;
            limit1 = (int)(value1 / size - (double)average) + average;
            int iv3 = Math.min(limit0, limit1);
            while (iv3 <= Math.max(limit0, limit1)) {
                double val = (double)iv3 * size;
                float tickPosition = Scale.interpolate(val, w2, value0, value1);
                Scale.addTickMark(primaryTicks, location, tickPosition, primaryTickSize);
                ++iv3;
            }
            int ndigits = (int)Math.floor(Math.log(size) / Math.log(10.0));
            ndigits = -Math.min(ndigits, 0);
            int zero = iv = Math.min(limit0, limit1);
            double val = (double)iv * size;
            float tickPosition = Scale.interpolate(val, w2, value0, value1);
            label[0] = Scale.fixedPrecision(val, ndigits);
            position[0] = tickPosition;
            iv = Math.max(limit0, limit1);
            val = (double)iv * size;
            tickPosition = Scale.interpolate(val, w2, value0, value1);
            label[1] = Scale.fixedPrecision(val, ndigits);
            position[1] = tickPosition;
            if ((zero *= iv) <= 0) {
                tickPosition = Scale.interpolate(0.0, w2, value0, value1);
                label[2] = Scale.fixedPrecision(0.0, ndigits);
                position[2] = tickPosition;
            } else {
                label[2] = null;
                position[2] = position[1];
            }
        }
    }

    private static float interpolate(double value, double size, double value0, double value1) {
        return (float)(size * (value - value0) / (value1 - value0));
    }

    public static String fixedPrecision(double d2, int ndigits) {
        String dstring = Double.toString(d2);
        StringBuffer buffer = new StringBuffer(dstring);
        int index = dstring.lastIndexOf(".");
        if (index < 0) {
            buffer.append(".");
            index = buffer.length() - 1;
        }
        buffer.setLength(index + ndigits + 1);
        int i2 = 0;
        while (i2 < buffer.length()) {
            if (buffer.charAt(i2) == '\u0000') {
                buffer.setCharAt(i2, '0');
            }
            ++i2;
        }
        return buffer.toString();
    }
}

