/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JToolBar;

public class ToolBarLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int align;
    int hgap;
    int vgap;

    public ToolBarLayout() {
        this(0, 5, 5);
    }

    public ToolBarLayout(int align) {
        this(align, 5, 5);
    }

    public ToolBarLayout(int align, int hgap, int vgap) {
        this.align = align;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int align) {
        this.align = align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
        try {
            ((JToolBar)comp).setOrientation(0);
        }
        catch (Exception e2) {}
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            Insets insets = target.getInsets();
            int numRows = 1;
            int rowSumWidth = insets.left + insets.right;
            int rowMaxWidth = target.getSize().width;
            int rowHeight = 0;
            int numOnRow = 0;
            int i2 = 0;
            while (i2 < nmembers) {
                Component m2 = target.getComponent(i2);
                if (m2.isVisible()) {
                    Dimension d2 = m2.getPreferredSize();
                    rowHeight = Math.max(rowHeight, d2.height);
                    if (i2 > 0) {
                        rowSumWidth += this.hgap;
                    }
                    if ((rowSumWidth += d2.width) + this.hgap > rowMaxWidth && numOnRow > 0) {
                        ++numRows;
                        rowSumWidth = insets.left + insets.right + d2.width;
                        numOnRow = 0;
                    }
                    ++numOnRow;
                }
                ++i2;
            }
            dim.width = rowMaxWidth;
            dim.height = insets.top + insets.bottom + numRows * rowHeight + this.vgap * (numRows - 1);
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            int i2 = 0;
            while (i2 < nmembers) {
                Component m2 = target.getComponent(i2);
                if (m2.isVisible()) {
                    Dimension d2 = m2.getMinimumSize();
                    dim.height = Math.max(dim.height, d2.height);
                    if (i2 > 0) {
                        dim.width += this.hgap;
                    }
                    dim.width += d2.width;
                }
                ++i2;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x2, int y2, int width, int height, int rowStart, int rowEnd) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.align) {
                case 0: {
                    break;
                }
                case 1: {
                    x2 += width / 2;
                    break;
                }
                case 2: {
                    x2 += width;
                }
            }
            int i2 = rowStart;
            while (i2 < rowEnd) {
                Component m2 = target.getComponent(i2);
                if (m2.isVisible()) {
                    m2.setLocation(x2, y2 + (height - m2.getSize().height) / 2);
                    x2 += this.hgap + m2.getSize().width;
                }
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxwidth = target.getSize().width - (insets.left + insets.right + this.hgap * 2);
            int nmembers = target.getComponentCount();
            int x2 = 0;
            int y2 = insets.top;
            int rowh = 0;
            int start = 0;
            int i2 = 0;
            while (i2 < nmembers) {
                Component m2 = target.getComponent(i2);
                if (m2.isVisible()) {
                    Dimension d2 = m2.getPreferredSize();
                    m2.setSize(d2.width, d2.height);
                    if (x2 == 0 || x2 + d2.width <= maxwidth) {
                        if (x2 > 0) {
                            x2 += this.hgap;
                        }
                        x2 += d2.width;
                        rowh = Math.max(rowh, d2.height);
                    } else {
                        this.moveComponents(target, insets.left + this.hgap, y2, maxwidth - x2, rowh, start, i2);
                        x2 = d2.width;
                        y2 += this.vgap + rowh;
                        rowh = d2.height;
                        start = i2;
                    }
                }
                ++i2;
            }
            this.moveComponents(target, insets.left + this.hgap, y2, maxwidth - x2, rowh, start, nmembers);
        }
    }

    public String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=left";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=right";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

