/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.FinishableOutputStream;

public class ASCIIHexOutputStream
extends FilterOutputStream
implements FinishableOutputStream {
    private static final int MAX_CHARS_PER_LINE = 80;
    private int characters = 80;
    private boolean end = false;

    public ASCIIHexOutputStream(OutputStream out) {
        super(out);
    }

    public void write(int b2) throws IOException {
        String s2 = Integer.toHexString(b2 & 0xFF);
        switch (s2.length()) {
            case 1: {
                this.writeChar(48);
                this.writeChar(s2.charAt(0));
                break;
            }
            case 2: {
                this.writeChar(s2.charAt(0));
                this.writeChar(s2.charAt(1));
                break;
            }
            default: {
                throw new IOException("ASCIIHexOutputStream: byte '" + b2 + "' was encoded in less than 1 or more than 2 chars");
            }
        }
    }

    public void finish() throws IOException {
        if (!this.end) {
            this.end = true;
            this.writeChar(62);
            this.flush();
            if (this.out instanceof FinishableOutputStream) {
                ((FinishableOutputStream)((Object)this.out)).finish();
            }
        }
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    private void writeChar(int b2) throws IOException {
        if (this.characters == 0) {
            this.characters = 80;
            super.write(10);
        }
        --this.characters;
        super.write(b2);
    }
}

