/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.DecompressableInputStream;

public class BitInputStream
extends DecompressableInputStream {
    protected static final int MASK_SIZE = 8;
    protected static final int ZERO = 0;
    protected static final int ONES = -1;
    protected static final int[] BIT_MASK = new int[8];
    protected static final int[] FIELD_MASK = new int[8];
    private int bits = 0;
    private int validBits = 0;

    public BitInputStream(InputStream in) {
        super(in);
    }

    protected void fetchByte() throws IOException {
        this.bits = this.read();
        if (this.bits < 0) {
            throw new EOFException();
        }
        this.validBits = 8;
    }

    public void byteAlign() {
        this.validBits = 0;
    }

    public boolean readBitFlag() throws IOException {
        if (this.validBits == 0) {
            this.fetchByte();
        }
        return (this.bits & BIT_MASK[--this.validBits]) != 0;
    }

    public long readSBits(int n2) throws IOException {
        if (n2 == 0) {
            return 0L;
        }
        int value = this.readBitFlag() ? -1 : 0;
        return (long)(value <<= --n2) | this.readUBits(n2);
    }

    public float readFBits(int n2) throws IOException {
        if (n2 == 0) {
            return 0.0f;
        }
        return (float)this.readSBits(n2) / 4096.0f;
    }

    public long readUBits(int n2) throws IOException {
        long value = 0L;
        while (n2 > 0) {
            if (this.validBits == 0) {
                this.fetchByte();
            }
            int nbits = n2 > this.validBits ? this.validBits : n2;
            int temp = this.bits >> this.validBits - nbits & FIELD_MASK[nbits - 1];
            this.validBits -= nbits;
            n2 -= nbits;
            value <<= nbits;
            value |= (long)temp;
        }
        return value;
    }

    static {
        int tempBit = 1;
        int tempField = 1;
        int i2 = 0;
        while (i2 < 8) {
            BitInputStream.BIT_MASK[i2] = tempBit;
            BitInputStream.FIELD_MASK[i2] = tempField;
            tempBit <<= 1;
            tempField <<= 1;
            ++tempField;
            ++i2;
        }
    }
}

