/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.freehep.util.io.BitOutputStream;

public class ByteOrderOutputStream
extends BitOutputStream
implements DataOutput {
    protected boolean little;
    protected int written;

    public ByteOrderOutputStream(OutputStream out) {
        this(out, false);
    }

    public ByteOrderOutputStream(OutputStream out, boolean littleEndian) {
        super(out);
        this.little = littleEndian;
        this.written = 0;
    }

    public int size() throws IOException {
        return this.written;
    }

    public synchronized void write(int b2) throws IOException {
        super.write(b2);
        ++this.written;
    }

    public void writeBoolean(boolean b2) throws IOException {
        if (b2) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeChar(int c2) throws IOException {
        if (this.little) {
            this.write(c2 & 0xFF);
            this.write(c2 >>> 8 & 0xFF);
        } else {
            this.write(c2 >>> 8 & 0xFF);
            this.write(c2 & 0xFF);
        }
    }

    public void writeByte(int b2) throws IOException {
        this.byteAlign();
        this.write(b2);
    }

    public void writeByte(byte[] bytes) throws IOException {
        this.byteAlign();
        int i2 = 0;
        while (i2 < bytes.length) {
            this.write(bytes[i2]);
            ++i2;
        }
    }

    public void writeUnsignedByte(int ub) throws IOException {
        this.byteAlign();
        this.write(ub);
    }

    public void writeUnsignedByte(int[] bytes) throws IOException {
        this.byteAlign();
        int i2 = 0;
        while (i2 < bytes.length) {
            this.write(bytes[i2]);
            ++i2;
        }
    }

    public void writeShort(int s2) throws IOException {
        this.byteAlign();
        if (this.little) {
            this.write(s2 & 0xFF);
            this.write(s2 >>> 8 & 0xFF);
        } else {
            this.write(s2 >>> 8 & 0xFF);
            this.write(s2 & 0xFF);
        }
    }

    public void writeShort(short[] shorts) throws IOException {
        int i2 = 0;
        while (i2 < shorts.length) {
            this.writeShort(shorts[i2]);
            ++i2;
        }
    }

    public void writeUnsignedShort(int s2) throws IOException {
        this.byteAlign();
        if (this.little) {
            this.write(s2 & 0xFF);
            this.write(s2 >>> 8 & 0xFF);
        } else {
            this.write(s2 >>> 8 & 0xFF);
            this.write(s2 & 0xFF);
        }
    }

    public void writeUnsignedShort(int[] shorts) throws IOException {
        int i2 = 0;
        while (i2 < shorts.length) {
            this.writeUnsignedShort(shorts[i2]);
            ++i2;
        }
    }

    public void writeInt(int i2) throws IOException {
        if (this.little) {
            this.write(i2 & 0xFF);
            this.write(i2 >>> 8 & 0xFF);
            this.write(i2 >>> 16 & 0xFF);
            this.write(i2 >>> 24 & 0xFF);
        } else {
            this.write(i2 >>> 24 & 0xFF);
            this.write(i2 >>> 16 & 0xFF);
            this.write(i2 >>> 8 & 0xFF);
            this.write(i2 & 0xFF);
        }
    }

    public void writeInt(int[] ints) throws IOException {
        int i2 = 0;
        while (i2 < ints.length) {
            this.writeInt(ints[i2]);
            ++i2;
        }
    }

    public void writeUnsignedInt(long i2) throws IOException {
        if (this.little) {
            this.write((int)(i2 & 0xFFL));
            this.write((int)(i2 >>> 8 & 0xFFL));
            this.write((int)(i2 >>> 16 & 0xFFL));
            this.write((int)(i2 >>> 24 & 0xFFL));
        } else {
            this.write((int)(i2 >>> 24 & 0xFFL));
            this.write((int)(i2 >>> 16 & 0xFFL));
            this.write((int)(i2 >>> 8 & 0xFFL));
            this.write((int)(i2 & 0xFFL));
        }
    }

    public void writeUnsignedInt(long[] ints) throws IOException {
        int i2 = 0;
        while (i2 < ints.length) {
            this.writeUnsignedInt(ints[i2]);
            ++i2;
        }
    }

    public void writeLong(long l2) throws IOException {
        if (this.little) {
            this.write((int)(l2 & 0xFFL));
            this.write((int)(l2 >>> 8 & 0xFFL));
            this.write((int)(l2 >>> 16 & 0xFFL));
            this.write((int)(l2 >>> 24 & 0xFFL));
            this.write((int)(l2 >>> 32 & 0xFFL));
            this.write((int)(l2 >>> 40 & 0xFFL));
            this.write((int)(l2 >>> 48 & 0xFFL));
            this.write((int)(l2 >>> 56 & 0xFFL));
        } else {
            this.write((int)(l2 >>> 56 & 0xFFL));
            this.write((int)(l2 >>> 48 & 0xFFL));
            this.write((int)(l2 >>> 40 & 0xFFL));
            this.write((int)(l2 >>> 32 & 0xFFL));
            this.write((int)(l2 >>> 24 & 0xFFL));
            this.write((int)(l2 >>> 16 & 0xFFL));
            this.write((int)(l2 >>> 8 & 0xFFL));
            this.write((int)(l2 & 0xFFL));
        }
    }

    public void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public void writeBytes(String s2) throws IOException {
        int i2 = 0;
        while (i2 < s2.length()) {
            this.writeByte(s2.charAt(i2));
            ++i2;
        }
    }

    public void writeChars(String s2) throws IOException {
        int i2 = 0;
        while (i2 < s2.length()) {
            this.writeChar(s2.charAt(i2));
            ++i2;
        }
    }

    public void writeString(String s2) throws IOException {
        this.writeUTF(s2);
    }

    public void writeUTF(String s2) throws IOException {
        ByteOrderOutputStream.writeUTF(s2, this);
    }

    public void writeAsciiZString(String s2) throws IOException {
        this.writeBytes(s2);
        this.writeByte(0);
    }

    public static void writeUTF(String s2, DataOutput dos) throws IOException {
        char c2;
        int strlen = s2.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        s2.getChars(0, strlen, charr, 0);
        int i2 = 0;
        while (i2 < strlen) {
            c2 = charr[i2];
            utflen = c2 >= '\u0001' && c2 <= '\u007f' ? ++utflen : (c2 > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i3 = 0;
        while (i3 < strlen) {
            c2 = charr[i3];
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                bytearr[count++] = (byte)c2;
            } else if (c2 > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            }
            ++i3;
        }
        dos.write(bytearr);
    }
}

