/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentPrintWriter
extends PrintWriter {
    private int indent = 0;
    private boolean indented = false;
    private String indentString = "  ";

    public IndentPrintWriter(Writer w2, int level) {
        super(w2);
        this.setIndent(level);
    }

    public IndentPrintWriter(Writer w2) {
        this(w2, 0);
    }

    public void print(boolean s2) {
        this.doIndent();
        super.print(s2);
    }

    public void print(char s2) {
        this.doIndent();
        super.print(s2);
    }

    public void print(char[] s2) {
        this.doIndent();
        super.print(s2);
    }

    public void print(double s2) {
        this.doIndent();
        super.print(s2);
    }

    public void print(float s2) {
        this.doIndent();
        super.print(s2);
    }

    public void print(int s2) {
        this.doIndent();
        super.print(s2);
    }

    public void print(long s2) {
        this.doIndent();
        super.print(s2);
    }

    public void print(Object s2) {
        this.doIndent();
        super.print(s2);
    }

    public void print(String s2) {
        this.doIndent();
        super.print(s2);
    }

    public void println() {
        this.indented = false;
        super.println();
    }

    private void doIndent() {
        if (this.indented) {
            return;
        }
        this.indented = true;
        int i2 = 0;
        while (i2 < this.indent) {
            super.print(this.indentString);
            ++i2;
        }
    }

    public void indent() {
        ++this.indent;
    }

    public void outdent() {
        --this.indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int level) {
        this.indent = level;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }
}

