/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.RunLength;

public class RunLengthInputStream
extends InputStream
implements RunLength {
    private boolean endReached;
    private int[] buffer = new int[128];
    private int index;
    private int count;
    private InputStream in;

    public RunLengthInputStream(InputStream input) {
        this.in = input;
        this.endReached = false;
        this.index = 0;
        this.count = 0;
    }

    public int read() throws IOException {
        if (!(this.index < this.count && this.index <= 128 || this.fillBuffer())) {
            return -1;
        }
        int b2 = this.buffer[this.index];
        ++this.index;
        return b2 & 0xFF;
    }

    private boolean fillBuffer() throws IOException {
        this.count = this.in.read();
        if (this.end(this.count)) {
            return false;
        }
        if (this.count < 128) {
            ++this.count;
            int i2 = 0;
            while (i2 < this.count) {
                this.buffer[i2] = this.in.read();
                if (this.end(this.buffer[i2])) {
                    return false;
                }
                ++i2;
            }
        } else {
            this.count = 257 - this.count;
            int b2 = this.in.read();
            if (this.end(b2)) {
                return false;
            }
            int i3 = 0;
            while (i3 < this.count) {
                this.buffer[i3] = b2;
                ++i3;
            }
        }
        this.index = 0;
        return true;
    }

    private boolean end(int b2) {
        if (b2 < 0 || b2 == 128) {
            this.endReached = true;
            return true;
        }
        return false;
    }
}

