#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <CON_All.h>

int initConsole(int& Width, int& Height, int& FullScreen, int& Flags, Screen* S)
{
  if (!S->isModeAvailable(640,480))
  {
    MessageBox(NULL,"Mode 640x480x16 not available","ERROR",MB_OK);
    return -1;
  }
  Width=640;
  Height=480;
  FullScreen=1;
  Flags=0;
  return 0;
}

// Function to draw text in a certain font at the center of the screen.
void drawText(Screen* S) 
{
  S->beginDraw();
  HDC dc=(HDC)S->getDeviceContext();
  SetTextColor(dc,0xFFFFFF);
  HFONT f=CreateFont(140,0,0,0,FW_EXTRABOLD,TRUE,FALSE,FALSE,
                     ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
                     DEFAULT_QUALITY,DEFAULT_PITCH,"Arial");
  HFONT old_f=(HFONT)SelectObject(dc,f);
  char Txt[] = "libCON";
  SIZE size;
  GetTextExtentPoint32(dc,Txt,strlen(Txt),&size);
  TextOut(dc,(640-size.cx)/2,(480-size.cy)/2,Txt,strlen(Txt));
  SelectObject(dc,old_f);
  DeleteObject(f);
  S->endDraw();
}

int Count=0;
enum { iter=1000 };

int action(Console* C)
{
  Screen* S=C->getScreen();
  if (Count==0)
  {
    S->clear(S->getColor(0,127,255));  // Bluish background
    S->setGammaFade(0.0f,0.0f,0.0f);  // Fade out completely (Dark)
    drawText(S);
    S->flip();   // Make sure the text is on display (primary)
    S->clear(S->getColor(0,127,255));  // Bluish background
    drawText(S); // Draw on the back buffer too!
    Sleep(500);
  }
  Sleep(1); // Delay
  Count++;
  float Ratio=0.0f;
  if (Count<iter) Ratio=Count*(1.0f/iter);
  if (Count>=iter && Count<=(2*iter)) Ratio=1.0f;
  if (Count>(2*iter) && Count<(3*iter)) Ratio=(3*iter-Count)*(1.0f/iter);
 
  long rc;
  rc=S->setGammaFade(Ratio,Ratio,Ratio); // Set the new fade value.
  if (rc<0)
  {
    S->beginDraw();
    S->printXY(200,400,0,"Gamma control not supported by your hardware!");
    S->endDraw();
    S->flip();
  }

  Keyboard& K=*C->getKeyboard();
  K.update();
  if (K[DIK_ESCAPE] || Count>(3*iter))
  {
    return 1;
  }
  return 0;
}