/** \file 2D_World.h
    A 2D World.  Holds sprites and tiles.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_2D_WORLD
#define H_2D_WORLD

#include <WO_World.h>
#include <WO_Collision.h>
#include <2D_Types.h>


/** An infinite 2D World.  Can contain a hierarchy of 2D objects,
    and has a view to reflect a certain part of it.
*/
class World2D : public Collidable_World
{
public:
  /** Construct a 2D World. */
  World2D();

  /** Destruct a 2D World. */
  ~World2D();

  // These methods override the ones defined in WO_World.h

  /** this checks to make sure that any Object added to a World2D
      is derived from Object2D.  Returns -1 if dynamic_cast fails. */
  virtual long add(Object* O);

//virtual long preRender(View& view);

  /** Returns the status of the object.  A non-zero value indicates an error. */
  long status() const { return m_Status; }

protected:
  long                  m_Status;
};

#endif // H_2D_WORLD