//
//                oooooooooo.
//                `888'   `Y8b
//                 888     888  .ooooo.    oooooooo  .ooooo.
//                 888oooo888' d88' `88b  d'""7d8P  d88' `88b
//                 888    `88b 888   888    .d8P'   888   888
//                 888    .88P 888   888  .d8P'  .P 888   888
//                o888bood8P'  `Y8bod8P' d8888888P  `Y8bod8P'
//                           _
//                          /_\     |    _  _ | _ ._
//                         /   \  \_||_|(_|(_||(/_|
//                                       _| _|
//                     Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon
//
// BZARtn
//
//      Bozo routine support.  This module provides the low-level
//  support required by the Bozo cooperative tasking system.  These
//  primitives should not be called directly by the application, but rather
//  provide building blocks for the tasking system.  These routines are
//  the implementation-specific parts of Bozo.  All other tasking
//  routines are implemented with these.
//
//  The two routines provided encapsulate the concept of the task portably
//  by using the ANSI-standard C routines setjmp() and longjmp().
//  corout()    fills a jmp_buf with implementation-dependent values so
//              that a long_jmp() with the buffer will switch the task
//              to execute the passed function on the passed stack.
//  swap()      saves the currently executing task into one buffer, and
//              "returns" into the second task.  When a task is switched
//              into, it appears to return from the swap() call.
//
//

#ifndef __BZ_COROUT_H
#define __BZ_COROUT_H 1

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

#ifdef __cplusplus
extern "C" {
#endif

//
//
//                                Includes
//
//

#include <setjmp.h>

//
//
//                                Equates
//
//

//
//
//                               Structures
//
//

#ifdef USE_SETJMP
typedef struct { jmp_buf jb; } bz_context;
#else
typedef struct { int jb[6]; } bz_context;
#endif

//
//
//                               Prototypes
//
//

void bz_corout (bz_context *, void (*)(void *), char *, int, void (*) (void), void *);
void bz_swap   (bz_context *, bz_context *);


#ifdef __cplusplus
};
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - bzartn.h 
