//
//
//                              S I M   G I N E
//
//             __               ___   ______,-------
//           __==__,------------/|\--|      | .-.-.|    ___________
//         (|     |--------------|---|------| '-`-`|  _/___________\_
//         (|_____|      _       _   |   _  | 6000 | |               |
//          |__\\_|`-._/___\___/___\_|_/___\|      | |               |
//         __/ |===|--|_____|_|_____|_|___  |\_____|=|_______________|
//      |=|[_]==[_]    \ _ /   \ _ /   \ _ /          [_]   [_]   [_]
//
//
//                     A Simluator Framework for MythOS(tm)
//
//                     Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1997-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon and Chuck Walbourn
//
// simui.cpp
//
// This module contains the SimulatorState user-interface base class.
//
//

//
//
//                                Includes
//
//

#include "simgine.hpp"

//
//
//                                 Code
//
//

//
//  Constructors/Destructors  
//

//
// SimUI - Constructor
//
SimUI::SimUI(SimulatorState *_parent) :
     parent(_parent),
     view (0),
     unit (0)
{
    assertMyth("SimUI needs valid parent", _parent != 0);
}


//
// SimUI - Destructor
//
SimUI::~SimUI()
{
    deactivate();
}



//
//  Operations  
//

//
// SimUI - activate
//
void SimUI::activate ()
{
    assertMyth("SimUI::activate needs valid starting view", view != 0);

    view->activate();
}


//
// SimUI - deactivate
//
void SimUI::deactivate ()
{
    if (view)
        view->deactivate();
}


//
// SimUI - process_events
//
void SimUI::process_events ()
{
    assertMyth("SimUI::process_events needs valid view", view != 0);

    view->process_events();
}


//
// SimUI - render
//
void SimUI::render ()
{
    assertMyth("SimUI::render needs valid view", view != 0);

    view->render();
}



//
//  Utility Routines  
//

// End of module - simui.cpp 

