//
//
//                                /\    /\
//                               /  \  /  \
//                              /    \/    \
//                             /  /\    /\  \
//                            /  /  \  /  Y T H O S
//                           /  /    \/    \  \
//                          /  /            \  \
//                         /__/              \__\
//
//                  Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// mytatext.c
//
// Contains the at-exit chain handling code.  This uses the standard
// atexit() routine to hook our handler so that the Mythos Collection only
// takes up a single atexit() entry in the system.
//
//

//
//
//                                Includes
//
//

#include <stdlib.h>

#include "mythos.h"

//
//
//                               Structures
//
//

typedef struct _AtExitType {
    void                ( *atexit_func )( void );
    struct _AtExitType  *atexit_next;
} AtExitType;

//
//
//                               Routines
//
//

static void mythos_atexit_handler(void);

//
//
//                                 Data
//
//

static AtExitType   *AtExit=0;

//
//
//                                 Code
//
//

//Ŀ
// mythos_atexit_handler                                                    
//                                                                          
// This is the handler for the single atexit() entry that is required for   
// the operation of this library.  An atexit handler can only be called ONCE
// since the chain is freed during callback.                                
//
static void mythos_atexit_handler(void)
{
    AtExitType *at, *nxt;

    for(at=AtExit; at != 0;) {
        if (at->atexit_func)
            at->atexit_func();
        nxt = at->atexit_next;
        at = nxt;
    }

    AtExit = 0;
}


//Ŀ
// mythos_atexit                                                            
//                                                                          
// Adds a function to the Mythos atexit chain.                              
//                                                                          
// Returns 0 if ok, non-zero on error.                                      
//
int mythos_atexit( register void ( *__func )( void ) )
{
    AtExitType  *at;

    // Can't use ivory, because it decommits memory on termination!
    // at = ivory_zalloc( sizeof(AtExitType) );
    at = malloc( sizeof(AtExitType) );
    if (!at)
        return 1;

    at->atexit_func = __func;
    at->atexit_next = AtExit;

    if (!AtExit) {
        atexit( mythos_atexit_handler);
    }
    AtExit = at;

    return 0;
}


//Ŀ
// mythos_atexit_remove                                                     
//                                                                          
// Removes a function from the Mythos atexit chain.                         
//
void mythos_atexit_remove( register void ( *__func )( void ) )
{
    AtExitType  *at;

    for(at=AtExit; at != 0; at = at->atexit_next) {
        if (at->atexit_func == __func) {
            at->atexit_func = 0;
            return;
        }
    }

    return;
}

// End of module - mytatext.c 

