//
//
//                                                           %__________%
//                                                          %/ . .  .   \%
//           Van Gogh 2D-Display Library                     |  . .  o. |
//                                                           |. _  .   .|
//        Microsoft Windows 95/98/NT Version                 | / \   .  |
//                                                           |_|_|_._._.|
//                                                           |.-.-.-.-..|
//                                                          %\__________/%
//                                                           %          %
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little
//
// thline128.cpp
//
//     The non-texturemapped horizontal scan line code.
//
//

//
//
//                                Includes
//
//

#include "debug.h"
#include "portable.h"
#include "vangogh.hpp"
#include <math.h>

//
//
//                                Equates
//
//


//
//
//                               Structures
//
//

extern long DitherMatrix[4][4];

//
//
//                               Routines
//
//


extern "C" void vngo_ghlines16 (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[tri->color];
    word             *stable = &tc->shl[0];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;

    long            sstep_dx1 = tri->sstep_dx1;

    word            *scrn = (word*)tri->sptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            start_y = tri->start_y;

    for (long y=0;y <= count;y++)
    {
        long ts = edge1->shade;

        long tx = edge1->x;
        word *ptr = scrn + tx;
        int dx = edge2->x;
        long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

        for (int x = tx;x < dx; x++)
        {
            long  matval = dmatrix[x&3];
            int ws = (ts + matval) >> 19;

            if (ws > 31)
                ws = 31;
            else if (ws < 0)
                ws = 0;

            *ptr = stable[ws];

            ptr++;
            ts += sstep_dx1;
        }
        scrn += pitch;
        edge1++;
        edge2++;
    }
}

extern "C" void vngo_hlines16 (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[tri->color];
    word             clr = tc->shl[tri->left_edge->shade >> 19];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;

    word            *scrn = (word*)tri->sptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            start_y = tri->start_y;

    for (long y=0;y <= count;y++)
    {
        long tx = edge1->x;
        word *ptr = scrn + tx;
        int dx = edge2->x;

        for (int x = tx;x < dx; x++)
        {
            *ptr = clr;
            ptr++;
        }
        scrn += pitch;
        edge1++;
        edge2++;
    }
}




// Zbuffered stuff.

extern "C" void vngo_zghlines16 (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[tri->color];
    word             *stable = &tc->shl[0];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;
    long            zpitch = tri->zpitch >> 1;

    long            zstep_dx1 = tri->zstep_dx1;
    long            sstep_dx1 = tri->sstep_dx1;

    word            *scrn = (word*)tri->sptr;
    word            *zbuff = (word*)tri->zptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            start_y = tri->start_y;

    for (long y=0;y <= count;y++)
    {
        long tz = edge1->z;
        long ts = edge1->shade;

        long tx = edge1->x;
        word *ptr = scrn + tx;
        word *zptr = zbuff + tx;
        int  dx = edge2->x;
        long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

        for (int x = tx;x < dx; x++)
        {
            word wz = word(tz >> 15);
            if (wz < *zptr)
            {
                *zptr = wz;
                int ws = (ts + dmatrix[x&3]) >> 19;

                if (ws > 31)
                    ws = 31;
                else if (ws < 0)
                    ws = 0;

                *ptr = stable[ws];
            }
            ptr++;
            zptr++;
            tz += zstep_dx1;
            ts += sstep_dx1;
        }
        scrn += pitch;
        zbuff += zpitch;
        edge1++;
        edge2++;
    }
}





extern "C" void vngo_zhlines16 (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[tri->color];
    word             clr = tc->shl[tri->left_edge->shade >> 19];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;
    long            zpitch = tri->zpitch >> 1;
    long            zstep_dx1 = tri->zstep_dx1;

    word            *scrn = (word*)tri->sptr;
    word            *zbuff = (word*)tri->zptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            start_y = tri->start_y;

    for (long y=0;y <= count;y++)
    {
        long tx = edge1->x;
        long tz = edge1->z;
        word *ptr = scrn + tx;
        word *zptr = zbuff + tx;
        int dx = edge2->x;

        for (int x = tx;x < dx; x++)
        {
            word wz = word(tz >> 15);
            if (wz < *zptr)
            {
                *zptr = wz;
                *ptr = clr;
            }

            ptr++;
            zptr++;
            tz += zstep_dx1;
        }
        scrn += pitch;
        zbuff += zpitch;
        edge1++;
        edge2++;
    }
}

