//
//
//           ^           **   **   **** ***** *    ****     ^      Take me to
//          (_)            * *     *      *   *    *       (_)    / your
//     ^                    *      **     *   *    **            ^  leader...
//    (_)       ^          * *     *      *   *    *            (_)
//             (_)       **   **   *    ***** **** ****
//
//                    Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// xfbitmap.hpp
//
// Contains the classes for working with bitmap files.
//
//

#ifndef __XFBITMAP_HPP
#define __XFBITMAP_HPP    1

#ifdef __WATCOMC__
#pragma pack(1);
#endif

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Includes
//
//

#include <ivory.hpp>

#include "xfbase.hpp"
#include "xfiff.hpp"

//
//
//                                Equates
//
//

#define XF_MAX_WIDTH    65535
#define XF_MAX_HEIGHT   65535

#define XF_XEB_COMPRESS_RLE     0
#define XF_XEB_COMPRESS_NONE    1

//
//
//                               Structures
//
//

struct XFXEBHeader
{
    ushort  version;
    ushort  width;
    ushort  height;
    byte    bpp;
    byte    compress;
    char    na[8];
};

//
//
//                                Classes
//
//

//Ŀ
// XFBitmap - Bitmap container class.                                       
//
class XFBitmap
{
public:
    word        flags;          // Flags for bitmap.
    ushort      width;          // X-size of bitmap
    ushort      height;         // Y-size of bitmap
    byte        bpp;            // Bytes per pixel for bitmap
    byte        clrinuse;       // Highest pal index in use
    dword       *pal;           // Pointer to locked palette data, if any.
    byte        *data;          // Pointer to locked bitmap data.
    IvoryHandle palhandle;      // Palette data handle (256 dword table)
    IvoryHandle handle;         // Bitmap handle

    //Ŀ
    // Constructor/Destructors                                              
    //
    XFBitmap();
    ~XFBitmap();

    //Ŀ
    // Operations                                                           
    //
    void release();

    xf_error_codes lock();
    void unlock();

    xf_error_codes create(ushort w, ushort h, byte _bpp=XFBM_BPP_8BIT,
                          int clear=1);

    byte *generate_mono(dword bgcolor);
};


//Ŀ
// XFParseBitmap - Abstract base object for reading/writing bitmap files.   
//
class XFParseBitmap
{
    XFileDiskBuf    xfile;
    XFBitmap        bitmap;

protected:
    XFile           *xf;
    xf_error_codes  errorn;

public:
    XFBitmap        *bm;

    //Ŀ
    // Constructor/Destructors                                              
    //
    XFParseBitmap();
    XFParseBitmap(XFile *f);
    XFParseBitmap(XFBitmap *b);
    XFParseBitmap(XFile *f, XFBitmap *b);

    virtual ~XFParseBitmap();

    //Ŀ
    // Operations                                                           
    //
    void attach(XFile *f) { if (!f) {xf=&xfile;} else {xf=f;} };

    xf_error_codes error(void) { return errorn; };

    xf_error_codes nameread(const char *name, XFBitmap *bm=0);
    virtual xf_error_codes read(XFBitmap *bm=0)=0;

    xf_error_codes namewrite(const char *name, XFBitmap *b=0);
    virtual xf_error_codes write(XFBitmap *b=0)=0;
};


//Ŀ
// XFParseBMP - Windows BMP format.                                         
//
class XFParseBMP : public XFParseBitmap
{
public:
    //Ŀ
    // Constructor/Destructors                                              
    //
    XFParseBMP() : XFParseBitmap() {}
    XFParseBMP(XFile *f) : XFParseBitmap(f) {}
    XFParseBMP(XFBitmap *b) : XFParseBitmap(b) {}
    XFParseBMP(XFile *f, XFBitmap *b) : XFParseBitmap(f,b) {}

    //Ŀ
    // Operations                                                           
    //
    virtual xf_error_codes read(XFBitmap *b=0);
    virtual xf_error_codes write(XFBitmap *b=0);
};


//Ŀ
// XFParseCEL - Autodesk's CEL format.                                      
//
class XFParseCEL : public XFParseBitmap
{
public:
    //Ŀ
    // Constructor/Destructors                                              
    //
    XFParseCEL() : XFParseBitmap()  {}
    XFParseCEL(XFile *f) : XFParseBitmap(f) {}
    XFParseCEL(XFBitmap *b) : XFParseBitmap(b) {}
    XFParseCEL(XFile *f, XFBitmap *b) : XFParseBitmap(f,b) {}

    //Ŀ
    // Operations                                                           
    //
    virtual xf_error_codes read(XFBitmap *b=0);
    virtual xf_error_codes write(XFBitmap *b=0);

    xf_error_codes read(ushort &xcoord, ushort &ycoord, XFBitmap *b=0);
    xf_error_codes write(ushort xcoord, ushort ycoord, XFBitmap *b=0);
};


//Ŀ
// XFParseLBM - IFF Standard ILBM format.                                   
//
class XFParseLBM : public XFParseBitmap
{
public:
    //Ŀ
    // Constructor/Destructors                                              
    //
    XFParseLBM() : XFParseBitmap()  {}
    XFParseLBM(XFile *f) : XFParseBitmap(f) {}
    XFParseLBM(XFBitmap *b) : XFParseBitmap(b) {}
    XFParseLBM(XFile *f, XFBitmap *b) : XFParseBitmap(f,b) {}

    //Ŀ
    // Operations                                                           
    //
    virtual xf_error_codes read(XFBitmap *b=0);
    virtual xf_error_codes write(XFBitmap *b=0);

    xf_error_codes read(XFParseIFF *iff, XFBitmap *b=0);
    xf_error_codes write(XFParseIFF *iff, XFBitmap *b=0);
};


//Ŀ
// XFParsePCX - Zsoft's PCX format.                                         
//
class XFParsePCX : public XFParseBitmap
{
public:
    //Ŀ
    // Constructor/Destructors                                              
    //
    XFParsePCX() : XFParseBitmap() {}
    XFParsePCX(XFile *f) : XFParseBitmap(f) {}
    XFParsePCX(XFBitmap *b) : XFParseBitmap(b) {}
    XFParsePCX(XFile *f, XFBitmap *b) : XFParseBitmap(f,b) {}

    //Ŀ
    // Operations                                                           
    //
    virtual xf_error_codes read(XFBitmap *b=0);
    virtual xf_error_codes write(XFBitmap *b=0);
};


//Ŀ
// XFParseTGA - TrueVision's Targa Format.                                  
//
class XFParseTGA : public XFParseBitmap
{
public:
    //Ŀ
    // Constructor/Destructors                                              
    //
    XFParseTGA() : XFParseBitmap()  {}
    XFParseTGA(XFile *f) : XFParseBitmap(f) {}
    XFParseTGA(XFBitmap *b) : XFParseBitmap(b) {}
    XFParseTGA(XFile *f, XFBitmap *b) : XFParseBitmap(f,b) {}

    //Ŀ
    // Operations                                                           
    //
    virtual xf_error_codes read(XFBitmap *b=0);
    virtual xf_error_codes write(XFBitmap *b=0);
};


//Ŀ
// XFParseXEB - Charybdis' XFile Encoded Bitmap format.                     
//
class XFParseXEB : public XFParseBitmap
{
public:
    //Ŀ
    // Constructor/Destructors                                              
    //
    XFParseXEB() : XFParseBitmap()  {}
    XFParseXEB(XFile *f) : XFParseBitmap(f) {}
    XFParseXEB(XFBitmap *b) : XFParseBitmap(b) {}
    XFParseXEB(XFile *f, XFBitmap *b) : XFParseBitmap(f,b) {}

    //Ŀ
    // Operations                                                           
    //
    virtual xf_error_codes read(XFBitmap *b=0);
    virtual xf_error_codes write(XFBitmap *b=0);

    xf_error_codes read(XFParseIFF *iff, XFBitmap *b=0);
    xf_error_codes write(XFParseIFF *iff, XFBitmap *b=0);

    //Ŀ
    // Utility members                                                      
    //
    static ulong compress_rle_mono(ushort w, ushort h,
                                   byte *data, byte *cdata);
    static int uncompress_rle_mono(ushort w, ushort h, ulong csize,
                                   byte *cdata, byte *data);

    static ulong compress_rle_8bpp(ushort w, ushort h,
                                   byte *data, byte *cdata);
    static int uncompress_rle_8bpp(ushort w, ushort h, ulong csize,
                                   byte *cdata, byte *data);

    static ulong compress_rle_16bpp(ushort w, ushort h,
                                    byte *data, byte *cdata);
    static int uncompress_rle_16bpp(ushort w, ushort h, ulong csize,
                                    byte *cdata, byte *data);

    static ulong compress_rle_24bpp(ushort w, ushort h,
                                    byte *data, byte *cdata);
    static int uncompress_rle_24bpp(ushort w, ushort h, ulong csize,
                                    byte *cdata, byte *data);

    static ulong compress_rle_32bpp(ushort w, ushort h,
                                    byte *data, byte *cdata);
    static int uncompress_rle_32bpp(ushort w, ushort h, ulong csize,
                                    byte *cdata, byte *data);
};

#ifdef __WATCOMC__
#pragma pack();
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - xfbitmap.hpp 

