//
//
//           ^           **   **   **** ***** *    ****     ^      Take me to
//          (_)            * *     *      *   *    *       (_)    / your
//     ^                    *      **     *   *    **            ^  leader...
//    (_)       ^          * *     *      *   *    *            (_)
//             (_)       **   **   *    ***** **** ****
//
//                    Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// xfbase.cpp
//
// Contains the code for the XFile abstract file object.
//
//

//
//
//                                Includes
//
//

#include "xfbase.hpp"

//
//
//                                Equates
//
//

#define XF_COPYBUFF 2048

//
//
//                                 Code
//
//

//
//  Constructors/Destructors  
//

//Ŀ
// XFile - Constructor                                                      
//
XFile::XFile() :
    sFlags(0),
    errorn(XF_ERR_NONE)
{
   *fName = 0;
}


//Ŀ
// XFile - Destructor                                                       
//
XFile::~XFile()
{
}



//
//  Operations  
//

//Ŀ
// XFile - copyto                                                           
//                                                                          
// Copies the file from the current position to the end of file to the      
// given file object.  The current position is moved to eof.                
//
xf_error_codes XFile::copyto(XFile *to)
{
   ulong size;
   char  buff[XF_COPYBUFF];

   for(;;)
   {
       size=read(buff,XF_COPYBUFF);

       if (size == -1)
           return error();

       if (size)
       {
           if (size !=  to->write(buff,size))
               return to->error();
       }
       if (size < XF_COPYBUFF)
           break;
   }

   return XF_ERR_NONE;
}


//Ŀ
// XFile - copyfrom                                                         
//                                                                          
// Copies from the given file to the file starting at the current position  
// until the from object reaches eof.                                       
//
xf_error_codes XFile::copyfrom(XFile *from)
{
   ulong size;
   char buff[XF_COPYBUFF];

   for(;;)
   {
       size=from->read(buff,XF_COPYBUFF);

       if (size == -1)
           return error();

       if (size)
       {
           if (size !=  write(buff,size))
               return error();
       }
       if (size < XF_COPYBUFF)
           break;
   }

   return XF_ERR_NONE;
}


//Ŀ
// XFile - flush                                                            
//
xf_error_codes XFile::flush(void)
{
   return XF_ERR_NONE;
}


//Ŀ
// XFile - lock                                                             
//
xf_error_codes XFile::lock(ulong offset, ulong nbytes)
{
   return XF_ERR_NONE;
}


//Ŀ
// XFile - unlock                                                           
//
xf_error_codes XFile::unlock(ulong offset, ulong nbytes)
{
   return XF_ERR_NONE;
}

// End of module - xfbase.cpp 

