/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.tiff.Decompressor;
import com.sun.jimi.core.decoder.tiff.TiffNumberReader;
import com.sun.jimi.core.util.lzw.LZWDecompressor;
import java.io.IOException;
import java.io.InputStream;

class LZWDecomp
extends Decompressor {
    int bitsperpixel_;
    byte[] bitPackedBuf_ = null;
    InputStream in_;
    LZWDecompressor decomp_;
    int predictor_;

    LZWDecomp(InputStream inputStream, int n, int n2, int n3) {
        super(new TiffNumberReader(new byte[1]), n, n2);
        this.in_ = inputStream;
        this.bitsperpixel_ = n2;
        this.predictor_ = n3;
        this.decomp_ = new LZWDecompressor(this.in_, 8, true);
    }

    public void begOfPage() {
    }

    public void begOfStrip() {
    }

    public void decodeLine(byte[] byArray, int n) throws JimiException {
        Thread.yield();
        try {
            switch (this.bitsperpixel_) {
                case 4: {
                    if (this.bitPackedBuf_ == null) {
                        this.bitPackedBuf_ = new byte[n + 1 >> 1];
                    }
                    int n2 = this.decomp_.decompress(this.bitPackedBuf_);
                    if (this.invertOut_) {
                        int n3 = this.bitPackedBuf_.length;
                        while (--n3 >= 0) {
                            this.bitPackedBuf_[n3] = ~this.bitPackedBuf_[n3];
                        }
                    }
                    System.arraycopy(this.bitPackedBuf_, 0, byArray, 0, this.bitPackedBuf_.length);
                    break;
                }
                case 1: 
                case 8: {
                    int n4 = this.decomp_.decompress(byArray);
                    if (this.invertOut_) {
                        int n5 = byArray.length;
                        while (--n5 >= 0) {
                            byArray[n5] = ~byArray[n5];
                        }
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            throw new JimiException("error unpacking data:" + iOException);
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.decomp_.setInputStream(inputStream);
    }
}

