/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class Brickworker
extends Component
implements Runnable {
    private static final int MAXFILESIZE = 150000;
    private int SAMPLEW = 1;
    private Bricktalk owner;
    private BrickCanvas bc;
    private boolean masterfinished = false;
    private Pic[] pics;
    private Masterpic master;
    private float pixelscaling;
    private int divx;
    private int divy;
    private String subpicpath;
    private String mastername;
    private int maxsubpicuses;
    private int resolution;
    private File outTIFname;
    private String libname;
    private boolean writelib;
    private boolean docomp;
    private Thread runner;
    private boolean keepgoing = true;

    public Brickworker(Bricktalk bricktalk, BrickCanvas brickCanvas, String string, String string2, int n, int n2, float f, String string3, int n3, String string4, boolean bl, boolean bl2, int n4) {
        this.owner = bricktalk;
        this.bc = brickCanvas;
        this.SAMPLEW = this.bc.getpx();
        this.pixelscaling = f;
        this.divx = n;
        this.divy = n2;
        this.subpicpath = string2;
        this.mastername = string;
        this.resolution = n3;
        this.outTIFname = new File(string3);
        this.libname = string4;
        this.writelib = bl;
        this.docomp = bl2;
        this.maxsubpicuses = n4;
        this.startbricklaying();
    }

    public void cancel() {
        this.keepgoing = false;
    }

    private void composite() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Graphics2D graphics2D;
        if (!this.keepgoing) {
            return;
        }
        PicShrink picShrink = new PicShrink();
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        int n7 = (int)(this.pixelscaling * (float)this.master.width / (float)this.master.blocksinx);
        int n8 = (int)(this.pixelscaling * (float)this.master.height / (float)this.master.blocksiny);
        int[] nArray = new int[n7];
        int n9 = (int)((float)this.master.width * this.pixelscaling);
        int n10 = (int)((float)this.master.height * this.pixelscaling);
        BuildTif buildTif = new BuildTif(n9, n10, this.outTIFname, this.resolution, this.resolution, true);
        int n11 = (int)((float)this.SAMPLEW / (float)this.master.width * (float)this.master.height);
        if (n11 < 1) {
            n11 = 1;
        }
        int n12 = this.SAMPLEW / this.master.blocksinx;
        int n13 = n11 / this.master.blocksiny;
        System.out.println("Composite: screen sample " + this.SAMPLEW + ", " + n11 + " with subpics " + n12 + ", " + n13);
        int[] nArray2 = new int[this.SAMPLEW * n11];
        int[] nArray3 = new int[n7 * n8];
        System.out.println("Composite: getting buffered image");
        BufferedImage bufferedImage = this.owner.getbufimg(this.SAMPLEW, n11);
        if (bufferedImage == null) {
            System.out.println("Composite: Buffered image is null!");
        }
        if ((graphics2D = bufferedImage.createGraphics()) == null) {
            System.out.println("Composite: trouble obtaining Graphics 2D");
        }
        System.out.println("Composite: Creating master composite.");
        System.out.println("Composite: compw, comph->" + n9 + ", " + n10 + "  subw, subh->" + n7 + ", " + n8);
        boolean bl = false;
        int n14 = 0;
        while (n14 < this.pics.length) {
            if (!this.keepgoing) {
                return;
            }
            if (n14 % 10 == 0) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                System.out.println("Composite: memory free " + runtime.freeMemory());
            }
            if (n14 % (int)((double)this.pics.length * 0.05 + 1.0) == 0) {
                int n15 = (int)((float)n14 / (float)(this.pics.length + 1) * 100.0f);
                if (n15 < 1) {
                    n15 = 1;
                }
                this.owner.setprogressDialog(n15);
                System.out.println("Composite: " + n15 + "% finished");
            }
            if (n14 % 100 == 0 && n14 != 0) {
                runtime.gc();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.pics[n14].gettimesused() > 0) {
                bl = true;
                this.saypicnpause(n14, false);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                Image image = picShrink.shrink2(this.owner, this.pics[n14].imagename, nArray3, n7, n12, n13);
                n6 = 0;
                while (n6 < this.pics[n14].gettimesused()) {
                    n5 = this.pics[n14].getmk(n6);
                    n4 = this.pics[n14].getml(n6);
                    graphics2D.drawImage(image, n5 * n12, n4 * n13, this);
                    n3 = 0;
                    while (n3 < n8) {
                        n2 = 0;
                        while (n2 < n7) {
                            nArray[n2] = nArray3[n2 + n3 * n7];
                            ++n2;
                        }
                        n = n5 * n7;
                        int n16 = n4 * n8 + n3;
                        buildTif.putpixels(n, n16, nArray);
                        ++n3;
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++n6;
                }
                image.flush();
            }
            if (bl) {
                this.bc.ready(bufferedImage);
                bl = false;
            }
            ++n14;
        }
        System.out.println("Composite: Filling holes with average colour");
        int n17 = 0;
        while (n17 < this.master.blocksiny) {
            n6 = 0;
            while (n6 < this.master.blocksinx) {
                if (!this.keepgoing) {
                    return;
                }
                if (this.master.picnumber[n6][n17] == -1) {
                    n5 = TriCol.buildpixel(this.master.avgR[n6][n17], this.master.avgG[n6][n17], this.master.avgB[n6][n17]);
                    n4 = 0;
                    while (n4 < n7) {
                        nArray[n4] = n5;
                        ++n4;
                    }
                    n3 = 0;
                    while (n3 < n8) {
                        n2 = n6 * n7;
                        n = n17 * n8 + n3;
                        buildTif.putpixels(n2, n, nArray);
                        ++n3;
                    }
                    graphics2D.setBackground(new Color(n5));
                    graphics2D.clearRect(n6 * n12, n17 * n13, n12, n13);
                }
                ++n6;
            }
            ++n17;
        }
        graphics2D.dispose();
        buildTif.fintif();
        this.masterfinished = true;
        this.bc.ready(bufferedImage);
        System.out.println("Composite: Finished TIF file and sample image!");
    }

    public static File[] listpics(File file) {
        Object object;
        Vector<File> vector = new Vector<File>();
        Vector<File> vector2 = new Vector<File>();
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                if (file2.isFile()) {
                    object = new String(stringArray[n]);
                    object = ((String)object).toLowerCase();
                    if (file2.length() < 150000L && ((String)object).endsWith(".jpg")) {
                        vector.addElement(file2);
                    }
                } else {
                    vector2.addElement(file2);
                }
                ++n;
            }
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {}
        File file3 = file;
        int n = 0;
        while (n < vector2.size()) {
            object = (File)vector2.elementAt(n);
            File[] fileArray = Brickworker.listpics((File)object);
            int n2 = 0;
            while (n2 < fileArray.length) {
                vector.addElement(fileArray[n2]);
                ++n2;
            }
            ++n;
        }
        object = new File[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private void masterschoices() {
        int n = 0;
        while (n < this.master.blocksiny) {
            int n2 = 0;
            while (n2 < this.master.blocksinx) {
                System.out.print(this.master.picnumber[n2][n]);
                ++n2;
            }
            System.out.println(" ");
            ++n;
        }
    }

    private void picassignments() {
        int n = 0;
        while (n < this.pics.length) {
            if (n % 20 == 0 && n != 0) {
                int n2 = (int)((float)n / (float)this.pics.length * 100.0f);
                System.out.println(String.valueOf(n2) + "% finished");
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String string = bufferedReader.readLine();
                }
                catch (IOException iOException) {}
            }
            this.pics[n].tellassignments();
            ++n;
        }
    }

    private void piccolours() {
        int n = 0;
        while (n < this.pics.length) {
            this.pics[n].tellcolours();
            ++n;
        }
    }

    private void rankblocks() {
        int[] nArray = new int[this.pics.length];
        int[] nArray2 = new int[this.pics.length];
        this.owner.setprogressDialog(1);
        int n = 0;
        while (n < this.master.blocksiny) {
            System.out.println("RankBlocks: " + (int)((float)n / (float)this.master.blocksiny * 100.0f) + "% finished");
            int n2 = 0;
            while (n2 < this.master.blocksinx) {
                if (!this.keepgoing) {
                    return;
                }
                int n3 = 0;
                while (n3 < this.pics.length) {
                    this.pics[n3].dR = Math.abs(this.pics[n3].avgR - this.master.avgR[n2][n]);
                    this.pics[n3].dG = Math.abs(this.pics[n3].avgG - this.master.avgG[n2][n]);
                    this.pics[n3].dB = Math.abs(this.pics[n3].avgB - this.master.avgB[n2][n]);
                    nArray[n3] = n3;
                    nArray2[n3] = this.pics[n3].dR;
                    ++n3;
                }
                Brickworker.sort(nArray, nArray2);
                int n4 = 0;
                while (n4 < this.pics.length) {
                    this.pics[nArray[n4]].rR = n4;
                    nArray[n4] = n4;
                    nArray2[n4] = this.pics[n4].dG;
                    ++n4;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
                Brickworker.sort(nArray, nArray2);
                int n5 = 0;
                while (n5 < this.pics.length) {
                    this.pics[nArray[n5]].rG = n5;
                    nArray[n5] = n5;
                    nArray2[n5] = this.pics[n5].dB;
                    ++n5;
                }
                Brickworker.sort(nArray, nArray2);
                int n6 = 0;
                while (n6 < this.pics.length) {
                    this.pics[nArray[n6]].rB = n6;
                    ++n6;
                }
                int n7 = 0;
                while (n7 < this.pics.length) {
                    this.pics[n7].avgrank = (int)((double)(this.pics[n7].rR + this.pics[n7].rG + this.pics[n7].rB) / 3.0);
                    nArray[n7] = n7;
                    nArray2[n7] = this.pics[n7].avgrank;
                    ++n7;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
                Brickworker.sort(nArray, nArray2);
                this.master.picnumber[n2][n] = -1;
                int n8 = 0;
                while (n8 < nArray.length) {
                    if (this.pics[nArray[n8]].isUsable() && this.pics[nArray[n8]].gettimesused() < this.maxsubpicuses) {
                        this.master.picnumber[n2][n] = nArray[n8];
                        this.pics[nArray[n8]].used = true;
                        this.pics[nArray[n8]].inc();
                        break;
                    }
                    ++n8;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void run() {
        this.owner.startprogressDialog(this);
        if (this.writelib) {
            System.out.println("Run: Searching for sub pictures");
            File[] fileArray = Brickworker.listpics(new File(this.subpicpath));
            System.out.println("Run: There are " + fileArray.length + " small pictures to work with.");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            this.pics = new Pic[fileArray.length];
            Runtime runtime = Runtime.getRuntime();
            int n = 0;
            while (n < fileArray.length) {
                if (!this.keepgoing) break;
                try {
                    this.pics[n] = new Pic(fileArray[n], n);
                }
                catch (Exception exception) {
                    System.out.print("Run: Pic constructor failed-> " + exception);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                if (n % (int)((double)fileArray.length * 0.05 + 1.0) == 0) {
                    int n2 = (int)((float)n / (float)(fileArray.length + 1) * 100.0f);
                    if (n2 < 1) {
                        n2 = 1;
                    }
                    this.owner.setprogressDialog(n2);
                    System.out.println("Run: " + n2 + "% finished");
                }
                if (n % 10 == 0) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    System.out.println("Run: memory free " + runtime.freeMemory());
                }
                if (n % 100 == 0) {
                    runtime.gc();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++n;
            }
            if (this.keepgoing) {
                System.out.println("Run: About to write library");
                boolean bl = LibFile.write(this.owner, this.pics, this.libname);
                if (!bl) {
                    this.owner.errlibwriting();
                }
            }
        } else {
            this.pics = LibFile.read(this.owner, this.libname);
            if (this.pics == null) {
                System.out.println("Run: Unable to open pic library, ending!");
                this.owner.errlibreading();
                Brick.notinprogress();
                return;
            }
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {}
        if (this.docomp) {
            this.master = new Masterpic(new File(this.mastername), this.divx, this.divy);
            if (!this.master.ready) {
                this.owner.errmasterreading();
                Brick.notinprogress();
                return;
            }
            this.rankblocks();
            if (this.keepgoing) {
                this.tellsubpics();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            if (this.keepgoing) {
                this.composite();
            }
            if (this.keepgoing) {
                this.owner.setmasterpic(this.master);
            }
        }
        if (!this.keepgoing) {
            System.out.println("Run: User cancelled operation.");
        }
        System.out.println("Run: Finishing up Brickworker");
        Brick.notinprogress();
        this.owner.endprogressDialog();
    }

    private void saypicnpause(int n, boolean bl) {
        block2: {
            System.out.println(String.valueOf(this.pics[n].imagename.toString()) + " is used " + this.pics[n].gettimesused() + " times.");
            if (!bl) break block2;
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = bufferedReader.readLine();
            }
            catch (IOException iOException) {}
        }
    }

    public static void sort(int[] nArray, int[] nArray2) {
        int n;
        int n2 = nArray2.length;
        if (n2 < 2) {
            return;
        }
        int n3 = (n2 >> 1) + 1;
        int n4 = n2;
        while (true) {
            int n5;
            if (n3 > 1) {
                n = nArray[--n3 - 1];
                n5 = nArray2[n];
            } else {
                n = nArray[n4 - 1];
                n5 = nArray2[n];
                nArray[n4 - 1] = nArray[0];
                if (--n4 == 1) break;
            }
            int n6 = n3;
            int n7 = n3 + n3;
            while (n7 <= n4) {
                if (n7 < n4 && nArray2[nArray[n7 - 1]] < nArray2[nArray[n7]]) {
                    ++n7;
                }
                if (n5 >= nArray2[nArray[n7 - 1]]) break;
                nArray[n6 - 1] = nArray[n7 - 1];
                n6 = n7;
                n7 <<= 1;
            }
            nArray[n6 - 1] = n;
        }
        nArray[0] = n;
    }

    public void startbricklaying() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.setPriority(1);
            this.runner.start();
        }
    }

    private void tellsubpics() {
        int n = 0;
        while (n < this.pics.length) {
            this.pics[n].setmkmlsize();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.master.blocksiny) {
            int n3 = 0;
            while (n3 < this.master.blocksinx) {
                if (this.master.picnumber[n3][n2] != -1) {
                    this.pics[this.master.picnumber[n3][n2]].assignmkml(n3, n2);
                }
                ++n3;
            }
            ++n2;
        }
    }
}

